/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.sparse;

import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.Scope;
import org.tensorflow.types.TInt64;
import org.tensorflow.types.family.TType;

public final class AddSparseToTensorsMap
extends RawOp
implements Operand<TInt64> {
    public static final String OP_NAME = "AddSparseToTensorsMap";
    private Output<TInt64> sparseHandle;

    public static AddSparseToTensorsMap create(Scope scope, Operand<TInt64> sparseIndices, Operand<? extends TType> sparseValues, Operand<TInt64> sparseShape, Options ... options) {
        OperationBuilder opBuilder = scope.env().opBuilder(OP_NAME, scope.makeOpName(OP_NAME));
        opBuilder.addInput(sparseIndices.asOutput());
        opBuilder.addInput(sparseValues.asOutput());
        opBuilder.addInput(sparseShape.asOutput());
        opBuilder = scope.apply(opBuilder);
        if (options != null) {
            for (Options opts : options) {
                if (opts.container != null) {
                    opBuilder.setAttr("container", opts.container);
                }
                if (opts.sharedName == null) continue;
                opBuilder.setAttr("shared_name", opts.sharedName);
            }
        }
        return new AddSparseToTensorsMap(opBuilder.build());
    }

    public static Options container(String container) {
        return new Options().container(container);
    }

    public static Options sharedName(String sharedName) {
        return new Options().sharedName(sharedName);
    }

    public Output<TInt64> sparseHandle() {
        return this.sparseHandle;
    }

    @Override
    public Output<TInt64> asOutput() {
        return this.sparseHandle;
    }

    private AddSparseToTensorsMap(Operation operation) {
        super(operation);
        int outputIdx = 0;
        this.sparseHandle = operation.output(outputIdx++);
    }

    public static class Options {
        private String container;
        private String sharedName;

        public Options container(String container) {
            this.container = container;
            return this;
        }

        public Options sharedName(String sharedName) {
            this.sharedName = sharedName;
            return this;
        }

        private Options() {
        }
    }
}

