/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.nn;

import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.Scope;
import org.tensorflow.types.family.TNumber;

public final class DataFormatDimMap<T extends TNumber>
extends RawOp
implements Operand<T> {
    public static final String OP_NAME = "DataFormatDimMap";
    private Output<T> y;

    public static <T extends TNumber> DataFormatDimMap<T> create(Scope scope, Operand<T> x, Options ... options) {
        OperationBuilder opBuilder = scope.env().opBuilder(OP_NAME, scope.makeOpName(OP_NAME));
        opBuilder.addInput(x.asOutput());
        opBuilder = scope.apply(opBuilder);
        if (options != null) {
            for (Options opts : options) {
                if (opts.srcFormat != null) {
                    opBuilder.setAttr("src_format", opts.srcFormat);
                }
                if (opts.dstFormat == null) continue;
                opBuilder.setAttr("dst_format", opts.dstFormat);
            }
        }
        return new DataFormatDimMap<T>(opBuilder.build());
    }

    public static Options srcFormat(String srcFormat) {
        return new Options().srcFormat(srcFormat);
    }

    public static Options dstFormat(String dstFormat) {
        return new Options().dstFormat(dstFormat);
    }

    public Output<T> y() {
        return this.y;
    }

    @Override
    public Output<T> asOutput() {
        return this.y;
    }

    private DataFormatDimMap(Operation operation) {
        super(operation);
        int outputIdx = 0;
        this.y = operation.output(outputIdx++);
    }

    public static class Options {
        private String srcFormat;
        private String dstFormat;

        public Options srcFormat(String srcFormat) {
            this.srcFormat = srcFormat;
            return this;
        }

        public Options dstFormat(String dstFormat) {
            this.dstFormat = dstFormat;
            return this;
        }

        private Options() {
        }
    }
}

