/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.io;

import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.Scope;
import org.tensorflow.types.TString;

public final class LmdbReader
extends RawOp
implements Operand<TString> {
    public static final String OP_NAME = "LMDBReader";
    private Output<TString> readerHandle;

    public static LmdbReader create(Scope scope, Options ... options) {
        OperationBuilder opBuilder = scope.env().opBuilder(OP_NAME, scope.makeOpName("LmdbReader"));
        opBuilder = scope.apply(opBuilder);
        if (options != null) {
            for (Options opts : options) {
                if (opts.container != null) {
                    opBuilder.setAttr("container", opts.container);
                }
                if (opts.sharedName == null) continue;
                opBuilder.setAttr("shared_name", opts.sharedName);
            }
        }
        return new LmdbReader(opBuilder.build());
    }

    public static Options container(String container) {
        return new Options().container(container);
    }

    public static Options sharedName(String sharedName) {
        return new Options().sharedName(sharedName);
    }

    public Output<TString> readerHandle() {
        return this.readerHandle;
    }

    @Override
    public Output<TString> asOutput() {
        return this.readerHandle;
    }

    private LmdbReader(Operation operation) {
        super(operation);
        int outputIdx = 0;
        this.readerHandle = operation.output(outputIdx++);
    }

    public static class Options {
        private String container;
        private String sharedName;

        public Options container(String container) {
            this.container = container;
            return this;
        }

        public Options sharedName(String sharedName) {
            this.sharedName = sharedName;
            return this;
        }

        private Options() {
        }
    }
}

