/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.estimator;

import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.Operands;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.Scope;
import org.tensorflow.types.TFloat32;
import org.tensorflow.types.TInt32;
import org.tensorflow.types.TString;

public final class BoostedTreesCalculateBestFeatureSplitV2
extends RawOp {
    public static final String OP_NAME = "BoostedTreesCalculateBestFeatureSplitV2";
    private Output<TInt32> nodeIds;
    private Output<TFloat32> gains;
    private Output<TInt32> featureIds;
    private Output<TInt32> featureDimensions;
    private Output<TInt32> thresholds;
    private Output<TFloat32> leftNodeContribs;
    private Output<TFloat32> rightNodeContribs;
    private Output<TString> splitWithDefaultDirections;

    public static BoostedTreesCalculateBestFeatureSplitV2 create(Scope scope, Operand<TInt32> nodeIdRange, Iterable<Operand<TFloat32>> statsSummariesList, Operand<TString> splitTypes, Operand<TInt32> candidateFeatureIds, Operand<TFloat32> l1, Operand<TFloat32> l2, Operand<TFloat32> treeComplexity, Operand<TFloat32> minNodeWeight, Long logitsDimension) {
        OperationBuilder opBuilder = scope.env().opBuilder(OP_NAME, scope.makeOpName(OP_NAME));
        opBuilder.addInput(nodeIdRange.asOutput());
        opBuilder.addInputList(Operands.asOutputs(statsSummariesList));
        opBuilder.addInput(splitTypes.asOutput());
        opBuilder.addInput(candidateFeatureIds.asOutput());
        opBuilder.addInput(l1.asOutput());
        opBuilder.addInput(l2.asOutput());
        opBuilder.addInput(treeComplexity.asOutput());
        opBuilder.addInput(minNodeWeight.asOutput());
        opBuilder = scope.apply(opBuilder);
        opBuilder.setAttr("logits_dimension", logitsDimension);
        return new BoostedTreesCalculateBestFeatureSplitV2(opBuilder.build());
    }

    public Output<TInt32> nodeIds() {
        return this.nodeIds;
    }

    public Output<TFloat32> gains() {
        return this.gains;
    }

    public Output<TInt32> featureIds() {
        return this.featureIds;
    }

    public Output<TInt32> featureDimensions() {
        return this.featureDimensions;
    }

    public Output<TInt32> thresholds() {
        return this.thresholds;
    }

    public Output<TFloat32> leftNodeContribs() {
        return this.leftNodeContribs;
    }

    public Output<TFloat32> rightNodeContribs() {
        return this.rightNodeContribs;
    }

    public Output<TString> splitWithDefaultDirections() {
        return this.splitWithDefaultDirections;
    }

    private BoostedTreesCalculateBestFeatureSplitV2(Operation operation) {
        super(operation);
        int outputIdx = 0;
        this.nodeIds = operation.output(outputIdx++);
        this.gains = operation.output(outputIdx++);
        this.featureIds = operation.output(outputIdx++);
        this.featureDimensions = operation.output(outputIdx++);
        this.thresholds = operation.output(outputIdx++);
        this.leftNodeContribs = operation.output(outputIdx++);
        this.rightNodeContribs = operation.output(outputIdx++);
        this.splitWithDefaultDirections = operation.output(outputIdx++);
    }
}

