/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.Output;
import org.tensorflow.op.Op;
import org.tensorflow.op.Scope;
import org.tensorflow.op.core.Constant;
import org.tensorflow.op.core.Fill;
import org.tensorflow.op.dtypes.Cast;
import org.tensorflow.types.TString;
import org.tensorflow.types.family.TNumber;
import org.tensorflow.types.family.TType;

public final class Ones<T extends TType>
implements Op,
Operand<T> {
    private final Fill<T> fill;

    public static <T extends TType> Ones<T> create(Scope scope, Operand<? extends TNumber> dims, Class<T> type) {
        Scope onesScope = scope.withSubScope("Ones");
        if (type == TString.class) {
            throw new IllegalArgumentException("Can't create Ones of String DataType");
        }
        Cast<T> one = Cast.create(onesScope.withName("One"), Constant.scalarOf(onesScope, 1), type, new Cast.Options[0]);
        return new Ones<T>(Fill.create(onesScope.withName("Fill"), dims, one));
    }

    @Override
    public Operation op() {
        return this.fill.op();
    }

    @Override
    public Output<T> asOutput() {
        return this.fill.asOutput();
    }

    private Ones(Fill<T> fill) {
        this.fill = fill;
    }
}

