/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.types;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.function.Function;
import org.tensorflow.Tensor;
import org.tensorflow.internal.buffer.StringTensorBuffer;
import org.tensorflow.internal.buffer.TensorBuffers;
import org.tensorflow.internal.c_api.TF_Tensor;
import org.tensorflow.ndarray.NdArray;
import org.tensorflow.ndarray.NdArrays;
import org.tensorflow.ndarray.Shape;
import org.tensorflow.ndarray.buffer.DataBuffer;
import org.tensorflow.ndarray.buffer.layout.DataLayout;
import org.tensorflow.ndarray.buffer.layout.DataLayouts;
import org.tensorflow.ndarray.impl.dense.DenseNdArray;
import org.tensorflow.types.TString;

class TStringImpl
extends DenseNdArray<String>
implements TString {
    private static DataLayout<DataBuffer<byte[]>, String> UTF_8_LAYOUT = DataLayouts.ofStrings(StandardCharsets.UTF_8);
    private final StringTensorBuffer tensorBuffer;

    @Override
    public TString using(Charset charset) {
        return new TStringImpl(this.tensorBuffer, DataLayouts.ofStrings(charset), this.shape());
    }

    @Override
    public NdArray<byte[]> asBytes() {
        return NdArrays.wrap(this.shape(), this.tensorBuffer);
    }

    static <T> Tensor<TString> createTensor(NdArray<T> src, Function<T, byte[]> getBytes) {
        long size = StringTensorBuffer.computeSize(src, getBytes);
        return Tensor.of(TString.DTYPE, src.shape(), size, data -> ((TStringImpl)data).tensorBuffer.init(src, getBytes));
    }

    static TString mapTensor(TF_Tensor nativeTensor, Shape shape) {
        StringTensorBuffer buffer = TensorBuffers.toStrings(nativeTensor, shape.size());
        return new TStringImpl(buffer, UTF_8_LAYOUT, shape);
    }

    private TStringImpl(StringTensorBuffer buffer, DataLayout<DataBuffer<byte[]>, String> layout, Shape shape) {
        super(layout.applyTo(buffer), shape);
        this.tensorBuffer = buffer;
    }
}

