/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.tpu;

import org.tensorflow.DataType;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.ndarray.Shape;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.Scope;
import org.tensorflow.types.family.TType;

public final class OutfeedDequeue<T extends TType>
extends RawOp
implements Operand<T> {
    public static final String OP_NAME = "OutfeedDequeue";
    private Output<T> output;

    public static <T extends TType> OutfeedDequeue<T> create(Scope scope, DataType<T> dtype, Shape shape, Options ... options) {
        OperationBuilder opBuilder = scope.env().opBuilder(OP_NAME, scope.makeOpName(OP_NAME));
        opBuilder = scope.applyControlDependencies(opBuilder);
        opBuilder.setAttr("dtype", dtype);
        opBuilder.setAttr("shape", shape);
        if (options != null) {
            for (Options opts : options) {
                if (opts.deviceOrdinal == null) continue;
                opBuilder.setAttr("device_ordinal", opts.deviceOrdinal);
            }
        }
        return new OutfeedDequeue<T>(opBuilder.build());
    }

    public static Options deviceOrdinal(Long deviceOrdinal) {
        return new Options().deviceOrdinal(deviceOrdinal);
    }

    public Output<T> output() {
        return this.output;
    }

    @Override
    public Output<T> asOutput() {
        return this.output;
    }

    private OutfeedDequeue(Operation operation) {
        super(operation);
        int outputIdx = 0;
        this.output = operation.output(outputIdx++);
    }

    public static class Options {
        private Long deviceOrdinal;

        public Options deviceOrdinal(Long deviceOrdinal) {
            this.deviceOrdinal = deviceOrdinal;
            return this;
        }

        private Options() {
        }
    }
}

