/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.strings;

import org.tensorflow.DataType;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.Scope;
import org.tensorflow.types.TInt32;
import org.tensorflow.types.TInt64;
import org.tensorflow.types.TString;
import org.tensorflow.types.family.TNumber;

public final class UnicodeDecode<T extends TNumber>
extends RawOp {
    public static final String OP_NAME = "UnicodeDecode";
    private Output<T> rowSplits;
    private Output<TInt32> charValues;

    public static <T extends TNumber> UnicodeDecode<T> create(Scope scope, Operand<TString> input, String inputEncoding, DataType<T> Tsplits, Options ... options) {
        OperationBuilder opBuilder = scope.env().opBuilder(OP_NAME, scope.makeOpName(OP_NAME));
        opBuilder.addInput(input.asOutput());
        opBuilder = scope.applyControlDependencies(opBuilder);
        opBuilder.setAttr("input_encoding", inputEncoding);
        opBuilder.setAttr("Tsplits", Tsplits);
        if (options != null) {
            for (Options opts : options) {
                if (opts.errors != null) {
                    opBuilder.setAttr("errors", opts.errors);
                }
                if (opts.replacementChar != null) {
                    opBuilder.setAttr("replacement_char", opts.replacementChar);
                }
                if (opts.replaceControlCharacters == null) continue;
                opBuilder.setAttr("replace_control_characters", opts.replaceControlCharacters);
            }
        }
        return new UnicodeDecode<T>(opBuilder.build());
    }

    public static UnicodeDecode<TInt64> create(Scope scope, Operand<TString> input, String inputEncoding, Options ... options) {
        return UnicodeDecode.create(scope, input, inputEncoding, TInt64.DTYPE, options);
    }

    public static Options errors(String errors) {
        return new Options().errors(errors);
    }

    public static Options replacementChar(Long replacementChar) {
        return new Options().replacementChar(replacementChar);
    }

    public static Options replaceControlCharacters(Boolean replaceControlCharacters) {
        return new Options().replaceControlCharacters(replaceControlCharacters);
    }

    public Output<T> rowSplits() {
        return this.rowSplits;
    }

    public Output<TInt32> charValues() {
        return this.charValues;
    }

    private UnicodeDecode(Operation operation) {
        super(operation);
        int outputIdx = 0;
        this.rowSplits = operation.output(outputIdx++);
        this.charValues = operation.output(outputIdx++);
    }

    public static class Options {
        private String errors;
        private Long replacementChar;
        private Boolean replaceControlCharacters;

        public Options errors(String errors) {
            this.errors = errors;
            return this;
        }

        public Options replacementChar(Long replacementChar) {
            this.replacementChar = replacementChar;
            return this;
        }

        public Options replaceControlCharacters(Boolean replaceControlCharacters) {
            this.replaceControlCharacters = replaceControlCharacters;
            return this;
        }

        private Options() {
        }
    }
}

