/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.sparse;

import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.Scope;
import org.tensorflow.types.TInt64;
import org.tensorflow.types.family.TNumber;

public final class DenseCountSparseOutput<U extends TNumber>
extends RawOp {
    public static final String OP_NAME = "DenseCountSparseOutput";
    private Output<TInt64> outputIndices;
    private Output<U> outputValues;
    private Output<TInt64> outputDenseShape;

    public static <U extends TNumber, T extends TNumber> DenseCountSparseOutput<U> create(Scope scope, Operand<T> values, Operand<U> weights, Boolean binaryOutput, Options ... options) {
        OperationBuilder opBuilder = scope.env().opBuilder(OP_NAME, scope.makeOpName(OP_NAME));
        opBuilder.addInput(values.asOutput());
        opBuilder.addInput(weights.asOutput());
        opBuilder = scope.applyControlDependencies(opBuilder);
        opBuilder.setAttr("binary_output", binaryOutput);
        if (options != null) {
            for (Options opts : options) {
                if (opts.minlength != null) {
                    opBuilder.setAttr("minlength", opts.minlength);
                }
                if (opts.maxlength == null) continue;
                opBuilder.setAttr("maxlength", opts.maxlength);
            }
        }
        return new DenseCountSparseOutput<U>(opBuilder.build());
    }

    public static Options minlength(Long minlength) {
        return new Options().minlength(minlength);
    }

    public static Options maxlength(Long maxlength) {
        return new Options().maxlength(maxlength);
    }

    public Output<TInt64> outputIndices() {
        return this.outputIndices;
    }

    public Output<U> outputValues() {
        return this.outputValues;
    }

    public Output<TInt64> outputDenseShape() {
        return this.outputDenseShape;
    }

    private DenseCountSparseOutput(Operation operation) {
        super(operation);
        int outputIdx = 0;
        this.outputIndices = operation.output(outputIdx++);
        this.outputValues = operation.output(outputIdx++);
        this.outputDenseShape = operation.output(outputIdx++);
    }

    public static class Options {
        private Long minlength;
        private Long maxlength;

        public Options minlength(Long minlength) {
            this.minlength = minlength;
            return this;
        }

        public Options maxlength(Long maxlength) {
            this.maxlength = maxlength;
            return this;
        }

        private Options() {
        }
    }
}

