/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.image;

import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.Scope;
import org.tensorflow.types.TFloat32;
import org.tensorflow.types.TInt32;

public final class CombinedNonMaxSuppression
extends RawOp {
    public static final String OP_NAME = "CombinedNonMaxSuppression";
    private Output<TFloat32> nmsedBoxes;
    private Output<TFloat32> nmsedScores;
    private Output<TFloat32> nmsedClasses;
    private Output<TInt32> validDetections;

    public static CombinedNonMaxSuppression create(Scope scope, Operand<TFloat32> boxes, Operand<TFloat32> scores, Operand<TInt32> maxOutputSizePerClass, Operand<TInt32> maxTotalSize, Operand<TFloat32> iouThreshold, Operand<TFloat32> scoreThreshold, Options ... options) {
        OperationBuilder opBuilder = scope.env().opBuilder(OP_NAME, scope.makeOpName(OP_NAME));
        opBuilder.addInput(boxes.asOutput());
        opBuilder.addInput(scores.asOutput());
        opBuilder.addInput(maxOutputSizePerClass.asOutput());
        opBuilder.addInput(maxTotalSize.asOutput());
        opBuilder.addInput(iouThreshold.asOutput());
        opBuilder.addInput(scoreThreshold.asOutput());
        opBuilder = scope.applyControlDependencies(opBuilder);
        if (options != null) {
            for (Options opts : options) {
                if (opts.padPerClass != null) {
                    opBuilder.setAttr("pad_per_class", opts.padPerClass);
                }
                if (opts.clipBoxes == null) continue;
                opBuilder.setAttr("clip_boxes", opts.clipBoxes);
            }
        }
        return new CombinedNonMaxSuppression(opBuilder.build());
    }

    public static Options padPerClass(Boolean padPerClass) {
        return new Options().padPerClass(padPerClass);
    }

    public static Options clipBoxes(Boolean clipBoxes) {
        return new Options().clipBoxes(clipBoxes);
    }

    public Output<TFloat32> nmsedBoxes() {
        return this.nmsedBoxes;
    }

    public Output<TFloat32> nmsedScores() {
        return this.nmsedScores;
    }

    public Output<TFloat32> nmsedClasses() {
        return this.nmsedClasses;
    }

    public Output<TInt32> validDetections() {
        return this.validDetections;
    }

    private CombinedNonMaxSuppression(Operation operation) {
        super(operation);
        int outputIdx = 0;
        this.nmsedBoxes = operation.output(outputIdx++);
        this.nmsedScores = operation.output(outputIdx++);
        this.nmsedClasses = operation.output(outputIdx++);
        this.validDetections = operation.output(outputIdx++);
    }

    public static class Options {
        private Boolean padPerClass;
        private Boolean clipBoxes;

        public Options padPerClass(Boolean padPerClass) {
            this.padPerClass = padPerClass;
            return this;
        }

        public Options clipBoxes(Boolean clipBoxes) {
            this.clipBoxes = clipBoxes;
            return this;
        }

        private Options() {
        }
    }
}

