/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.data;

import java.util.List;
import org.tensorflow.DataType;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.ndarray.Shape;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.Scope;
import org.tensorflow.types.TBool;
import org.tensorflow.types.TInt64;
import org.tensorflow.types.family.TType;

public final class BatchDataset
extends RawOp
implements Operand<TType> {
    public static final String OP_NAME = "BatchDatasetV2";
    private Output<?> handle;

    public static BatchDataset create(Scope scope, Operand<?> inputDataset, Operand<TInt64> batchSize, Operand<TBool> dropRemainder, List<DataType<?>> outputTypes, List<Shape> outputShapes, Options ... options) {
        OperationBuilder opBuilder = scope.env().opBuilder(OP_NAME, scope.makeOpName("BatchDataset"));
        opBuilder.addInput(inputDataset.asOutput());
        opBuilder.addInput(batchSize.asOutput());
        opBuilder.addInput(dropRemainder.asOutput());
        opBuilder = scope.applyControlDependencies(opBuilder);
        DataType[] outputTypesArray = new DataType[outputTypes.size()];
        for (int i = 0; i < outputTypesArray.length; ++i) {
            outputTypesArray[i] = outputTypes.get(i);
        }
        opBuilder.setAttr("output_types", outputTypesArray);
        Shape[] outputShapesArray = new Shape[outputShapes.size()];
        for (int i = 0; i < outputShapesArray.length; ++i) {
            outputShapesArray[i] = outputShapes.get(i);
        }
        opBuilder.setAttr("output_shapes", outputShapesArray);
        if (options != null) {
            for (Options opts : options) {
                if (opts.parallelCopy == null) continue;
                opBuilder.setAttr("parallel_copy", opts.parallelCopy);
            }
        }
        return new BatchDataset(opBuilder.build());
    }

    public static Options parallelCopy(Boolean parallelCopy) {
        return new Options().parallelCopy(parallelCopy);
    }

    public Output<?> handle() {
        return this.handle;
    }

    @Override
    public Output<TType> asOutput() {
        return this.handle;
    }

    private BatchDataset(Operation operation) {
        super(operation);
        int outputIdx = 0;
        this.handle = operation.output(outputIdx++);
    }

    public static class Options {
        private Boolean parallelCopy;

        public Options parallelCopy(Boolean parallelCopy) {
            this.parallelCopy = parallelCopy;
            return this;
        }

        private Options() {
        }
    }
}

