/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.pytorch.zoo.nlp.qa;

import ai.djl.Model;
import ai.djl.modality.nlp.Vocabulary;
import ai.djl.modality.nlp.bert.BertToken;
import ai.djl.modality.nlp.bert.BertTokenizer;
import ai.djl.modality.nlp.qa.QAInput;
import ai.djl.modality.nlp.translator.QATranslator;
import ai.djl.ndarray.NDArray;
import ai.djl.ndarray.NDList;
import ai.djl.ndarray.NDManager;
import ai.djl.pytorch.zoo.nlp.PtBertVocabulary;
import ai.djl.translate.TranslatorContext;
import java.io.IOException;
import java.util.List;

public class PtBertQATranslator
extends QATranslator {
    private List<String> tokens;
    private Vocabulary vocabulary;
    private BertTokenizer tokenizer;

    PtBertQATranslator(Builder builder) {
        super((QATranslator.BaseBuilder)builder);
    }

    public void prepare(NDManager manager, Model model) throws IOException {
        this.vocabulary = (Vocabulary)model.getArtifact("bert-base-uncased-vocab.txt", PtBertVocabulary::parse);
        this.tokenizer = new BertTokenizer();
    }

    public NDList processInput(TranslatorContext ctx, QAInput input) {
        BertToken token = this.tokenizer.encode(input.getQuestion().toLowerCase(), input.getParagraph().toLowerCase());
        this.tokens = token.getTokens();
        NDManager manager = ctx.getNDManager();
        long[] indices = this.tokens.stream().mapToLong(arg_0 -> ((Vocabulary)this.vocabulary).getIndex(arg_0)).toArray();
        long[] attentionMask = token.getAttentionMask().stream().mapToLong(i -> i).toArray();
        long[] tokenType = token.getTokenTypes().stream().mapToLong(i -> i).toArray();
        NDArray indicesArray = manager.create(indices);
        NDArray attentionMaskArray = manager.create(attentionMask);
        NDArray tokenTypeArray = manager.create(tokenType);
        return new NDList(new NDArray[]{indicesArray, attentionMaskArray, tokenTypeArray});
    }

    public String processOutput(TranslatorContext ctx, NDList list) {
        NDArray startLogits = (NDArray)list.get(0);
        NDArray endLogits = (NDArray)list.get(1);
        int startIdx = (int)startLogits.argMax().getLong(new long[0]);
        int endIdx = (int)endLogits.argMax().getLong(new long[0]);
        return this.tokens.subList(startIdx, endIdx + 1).toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends QATranslator.BaseBuilder<Builder> {
        protected Builder self() {
            return this;
        }

        protected PtBertQATranslator build() {
            return new PtBertQATranslator(this);
        }
    }
}

