/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.pytorch.zoo.nlp;

import ai.djl.modality.nlp.Vocabulary;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.LinkedHashMap;
import java.util.Map;

public final class PtBertVocabulary
implements Vocabulary {
    private Map<Long, String> vocabMap;
    private Map<String, Long> indicesMap;

    private PtBertVocabulary(Map<Long, String> vocabMap, Map<String, Long> indicesMap) {
        this.vocabMap = vocabMap;
        this.indicesMap = indicesMap;
    }

    public static PtBertVocabulary parse(Path path) {
        try {
            return PtBertVocabulary.parse(Files.newInputStream(path, new OpenOption[0]));
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public static PtBertVocabulary parse(String url) {
        try {
            return PtBertVocabulary.parse(new URL(url).openStream());
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static PtBertVocabulary parse(InputStream is) {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));){
            long i = 0L;
            LinkedHashMap<Long, String> vocabMap = new LinkedHashMap<Long, String>();
            LinkedHashMap<String, Long> indicesMap = new LinkedHashMap<String, Long>();
            while (reader.ready()) {
                String line = reader.readLine();
                vocabMap.put(i, line);
                indicesMap.put(line, i);
                ++i;
            }
            PtBertVocabulary ptBertVocabulary = new PtBertVocabulary(vocabMap, indicesMap);
            return ptBertVocabulary;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public long getIndex(String token) {
        return this.indicesMap.containsKey(token) ? this.indicesMap.get(token).longValue() : this.indicesMap.get("[UNK]").longValue();
    }

    public long size() {
        return this.indicesMap.size();
    }

    public String getToken(long index) {
        return this.vocabMap.get(index);
    }
}

