/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.pytorch.zoo.cv.classification;

import ai.djl.Application;
import ai.djl.Device;
import ai.djl.MalformedModelException;
import ai.djl.Model;
import ai.djl.modality.Classifications;
import ai.djl.modality.cv.Image;
import ai.djl.modality.cv.transform.Normalize;
import ai.djl.modality.cv.transform.Resize;
import ai.djl.modality.cv.transform.ToTensor;
import ai.djl.modality.cv.translator.ImageClassificationTranslator;
import ai.djl.modality.cv.translator.wrapper.FileTranslatorFactory;
import ai.djl.modality.cv.translator.wrapper.InputStreamTranslatorFactory;
import ai.djl.modality.cv.translator.wrapper.UrlTranslatorFactory;
import ai.djl.pytorch.zoo.PtModelZoo;
import ai.djl.repository.MRL;
import ai.djl.repository.Repository;
import ai.djl.repository.zoo.BaseModelLoader;
import ai.djl.repository.zoo.Criteria;
import ai.djl.repository.zoo.ModelNotFoundException;
import ai.djl.repository.zoo.ModelZoo;
import ai.djl.repository.zoo.ZooModel;
import ai.djl.translate.Transform;
import ai.djl.translate.Translator;
import ai.djl.translate.TranslatorFactory;
import ai.djl.util.Pair;
import ai.djl.util.Progress;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Path;
import java.util.Map;

public abstract class ImageClassificationModelLoader
extends BaseModelLoader<Image, Classifications> {
    private static final Application APPLICATION = Application.CV.IMAGE_CLASSIFICATION;
    private static final String GROUP_ID = "ai.djl.pytorch";
    private static final float[] MEAN = new float[]{0.485f, 0.456f, 0.406f};
    private static final float[] STD = new float[]{0.229f, 0.224f, 0.225f};

    public ImageClassificationModelLoader(Repository repository, String artifactId, String version) {
        super(repository, MRL.model((Application)APPLICATION, (String)GROUP_ID, (String)artifactId), version, (ModelZoo)new PtModelZoo());
        FactoryImpl factory = new FactoryImpl();
        this.factories.put(new Pair(Image.class, Classifications.class), factory);
        this.factories.put(new Pair(Path.class, Classifications.class), new FileTranslatorFactory((TranslatorFactory)factory));
        this.factories.put(new Pair(URL.class, Classifications.class), new UrlTranslatorFactory((TranslatorFactory)factory));
        this.factories.put(new Pair(InputStream.class, Classifications.class), new InputStreamTranslatorFactory((TranslatorFactory)factory));
    }

    public Application getApplication() {
        return APPLICATION;
    }

    public ZooModel<Image, Classifications> loadModel(Map<String, String> filters, Device device, Progress progress) throws IOException, ModelNotFoundException, MalformedModelException {
        Criteria criteria = Criteria.builder().setTypes(Image.class, Classifications.class).optFilters(filters).optDevice(device).optProgress(progress).build();
        return this.loadModel(criteria);
    }

    private static final class FactoryImpl
    implements TranslatorFactory<Image, Classifications> {
        private FactoryImpl() {
        }

        public Translator<Image, Classifications> newInstance(Model model, Map<String, Object> arguments) {
            int width = ((Double)arguments.getOrDefault("width", 256.0)).intValue();
            int height = ((Double)arguments.getOrDefault("height", 256.0)).intValue();
            String flag = (String)arguments.getOrDefault("flag", Image.Flag.COLOR.name());
            return ((ImageClassificationTranslator.Builder)((ImageClassificationTranslator.Builder)((ImageClassificationTranslator.Builder)((ImageClassificationTranslator.Builder)ImageClassificationTranslator.builder().optFlag(Image.Flag.valueOf((String)flag))).addTransform((Transform)new Resize(width, height))).addTransform((Transform)new ToTensor())).addTransform((Transform)new Normalize(MEAN, STD))).optApplySoftmax(true).build();
        }
    }
}

