/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.pytorch.zoo.nlp.qa;

import ai.djl.modality.nlp.bert.BertVocabulary;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashMap;
import java.util.Map;

public final class PtBertVocabulary
extends BertVocabulary {
    private Map<Long, String> vocabMap = new LinkedHashMap<Long, String>();
    private Map<String, Long> indicesMap = new LinkedHashMap<String, Long>();

    private PtBertVocabulary(InputStream is) {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));){
            long i = 0L;
            while (reader.ready()) {
                String line = reader.readLine();
                this.vocabMap.put(i, line);
                this.indicesMap.put(line, i);
                ++i;
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public static PtBertVocabulary parse(InputStream is) {
        return new PtBertVocabulary(is);
    }

    public long getIndex(String token) {
        return this.indicesMap.containsKey(token) ? this.indicesMap.get(token).longValue() : this.indicesMap.get("[UNK]").longValue();
    }

    public String getToken(long index) {
        return this.vocabMap.get(index);
    }
}

