/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.pytorch.zoo;

import ai.djl.Application;
import ai.djl.repository.MRL;
import ai.djl.repository.Repository;
import ai.djl.repository.zoo.BaseModelLoader;
import ai.djl.repository.zoo.ModelLoader;
import ai.djl.repository.zoo.ModelZoo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public class PtModelZoo
extends ModelZoo {
    private static final String DJL_REPO_URL = "https://mlrepo.djl.ai/";
    private static final Repository REPOSITORY = Repository.newInstance((String)"PyTorch", (String)"https://mlrepo.djl.ai/");
    public static final String GROUP_ID = "ai.djl.pytorch";
    private static final List<ModelLoader> MODEL_LOADERS = new ArrayList<ModelLoader>();

    public List<ModelLoader> getModelLoaders() {
        return MODEL_LOADERS;
    }

    public String getGroupId() {
        return GROUP_ID;
    }

    public Set<String> getSupportedEngines() {
        return Collections.singleton("PyTorch");
    }

    static {
        MRL resnet = REPOSITORY.model(Application.CV.IMAGE_CLASSIFICATION, GROUP_ID, "resnet", "0.0.1");
        MODEL_LOADERS.add((ModelLoader)new BaseModelLoader(resnet));
        MRL ssd = REPOSITORY.model(Application.CV.OBJECT_DETECTION, GROUP_ID, "ssd", "0.0.1");
        MODEL_LOADERS.add((ModelLoader)new BaseModelLoader(ssd));
        MRL bertQa = REPOSITORY.model(Application.NLP.QUESTION_ANSWER, GROUP_ID, "bertqa", "0.0.1");
        MODEL_LOADERS.add((ModelLoader)new BaseModelLoader(bertQa));
        MRL sentimentAnalysis = REPOSITORY.model(Application.NLP.SENTIMENT_ANALYSIS, GROUP_ID, "distilbert", "0.0.1");
        MODEL_LOADERS.add((ModelLoader)new BaseModelLoader(sentimentAnalysis));
        MRL bigGan = REPOSITORY.model(Application.CV.IMAGE_GENERATION, GROUP_ID, "biggan-deep", "0.0.1");
        MODEL_LOADERS.add((ModelLoader)new BaseModelLoader(bigGan));
        MRL cyclegan = REPOSITORY.model(Application.CV.IMAGE_GENERATION, GROUP_ID, "cyclegan", "0.0.1");
        MODEL_LOADERS.add((ModelLoader)new BaseModelLoader(cyclegan));
    }
}

