/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.pytorch.engine;

import ai.djl.Device;
import ai.djl.engine.Engine;
import ai.djl.ndarray.BaseNDManager;
import ai.djl.ndarray.NDArray;
import ai.djl.ndarray.NDManager;
import ai.djl.ndarray.types.DataType;
import ai.djl.ndarray.types.Shape;
import ai.djl.ndarray.types.SparseFormat;
import ai.djl.pytorch.engine.PtNDArray;
import ai.djl.pytorch.jni.JniUtils;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class PtNDManager
extends BaseNDManager {
    private static final PtNDManager SYSTEM_MANAGER = new SystemManager();

    private PtNDManager(NDManager parent, Device device) {
        super(parent, device);
    }

    static PtNDManager getSystemManager() {
        return SYSTEM_MANAGER;
    }

    public ByteBuffer allocateDirect(int capacity) {
        return ByteBuffer.allocateDirect(capacity).order(ByteOrder.nativeOrder());
    }

    public PtNDArray from(NDArray array) {
        if (array == null || array instanceof PtNDArray) {
            return (PtNDArray)array;
        }
        return this.create(array.toByteBuffer(), array.getShape(), array.getDataType());
    }

    public PtNDArray create(Shape shape, DataType dataType) {
        return JniUtils.createEmptyNdArray(this, shape, dataType, this.device, SparseFormat.DENSE);
    }

    public PtNDArray create(Buffer data, Shape shape, DataType dataType) {
        int size = Math.toIntExact(shape.size());
        BaseNDManager.validateBufferSize((Buffer)data, (DataType)dataType, (int)size);
        if (data.isDirect() && data instanceof ByteBuffer) {
            return JniUtils.createNdFromByteBuffer(this, (ByteBuffer)data, shape, dataType, SparseFormat.DENSE, this.device);
        }
        ByteBuffer buf = this.allocateDirect(size * dataType.getNumOfBytes());
        PtNDManager.copyBuffer((Buffer)data, (ByteBuffer)buf);
        return JniUtils.createNdFromByteBuffer(this, buf, shape, dataType, SparseFormat.DENSE, this.device);
    }

    /*
     * Exception decompiling
     */
    public NDArray createCoo(Buffer data, long[][] indices, Shape shape) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public NDArray zeros(Shape shape, DataType dataType) {
        return JniUtils.createZerosNdArray(this, shape, dataType, this.device, SparseFormat.DENSE);
    }

    public NDArray ones(Shape shape, DataType dataType) {
        return JniUtils.createOnesNdArray(this, shape, dataType, this.device, SparseFormat.DENSE);
    }

    public NDArray full(Shape shape, float value, DataType dataType) {
        return JniUtils.full(this, shape, value, dataType, this.device, SparseFormat.DENSE);
    }

    public NDArray arange(int start, int stop, int step, DataType dataType) {
        return this.arange(start, stop, step, dataType, this.device);
    }

    public NDArray arange(float start, float stop, float step, DataType dataType) {
        if (Math.signum(stop - start) != Math.signum(step)) {
            return this.create(new Shape(new long[]{0L}), dataType, this.device);
        }
        return JniUtils.arange(this, start, stop, step, dataType, this.device, SparseFormat.DENSE);
    }

    public NDArray eye(int rows, int cols, int k, DataType dataType) {
        if (k != 0) {
            throw new UnsupportedOperationException("index of the diagonal is not supported in PyTorch");
        }
        return JniUtils.eye(this, rows, cols, dataType, this.device, SparseFormat.DENSE);
    }

    public NDArray linspace(float start, float stop, int num, boolean endpoint) {
        if (!endpoint) {
            throw new UnsupportedOperationException("endpoint only support true");
        }
        return JniUtils.linspace(this, start, stop, num, DataType.FLOAT32, this.device, SparseFormat.DENSE);
    }

    public NDArray randomInteger(long low, long high, Shape shape, DataType dataType) {
        return JniUtils.randint(this, low, high, shape, dataType, this.device);
    }

    public NDArray randomUniform(float low, float high, Shape shape, DataType dataType) {
        return JniUtils.uniform(this, low, high, shape, dataType, this.device);
    }

    public NDArray randomNormal(float loc, float scale, Shape shape, DataType dataType) {
        return JniUtils.normal(this, loc, scale, shape, dataType, this.device);
    }

    public PtNDManager newSubManager(Device device) {
        PtNDManager manager = new PtNDManager((NDManager)this, device);
        this.attachInternal(manager.uid, (AutoCloseable)((Object)manager));
        return manager;
    }

    public final Engine getEngine() {
        return Engine.getEngine((String)"PyTorch");
    }

    private static final class SystemManager
    extends PtNDManager {
        SystemManager() {
            super(null, null);
        }

        public void attachInternal(String resourceId, AutoCloseable resource) {
        }

        public void detachInternal(String resourceId) {
        }

        public void close() {
        }
    }
}

