/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.onnxruntime.engine;

import ai.djl.Device;
import ai.djl.engine.Engine;
import ai.djl.engine.EngineException;
import ai.djl.ndarray.BaseNDManager;
import ai.djl.ndarray.NDArray;
import ai.djl.ndarray.NDList;
import ai.djl.ndarray.NDManager;
import ai.djl.ndarray.types.DataType;
import ai.djl.ndarray.types.Shape;
import ai.djl.onnxruntime.engine.OrtNDArray;
import ai.djl.onnxruntime.engine.OrtUtils;
import ai.djl.util.PairList;
import ai.onnxruntime.OnnxTensor;
import ai.onnxruntime.OrtEnvironment;
import ai.onnxruntime.OrtException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.file.Path;

public class OrtNDManager
extends BaseNDManager {
    private static final OrtNDManager SYSTEM_MANAGER = new SystemManager();
    private OrtEnvironment env;

    private OrtNDManager(NDManager parent, Device device, OrtEnvironment env) {
        super(parent, device);
        this.env = env;
    }

    static OrtNDManager getSystemManager() {
        return SYSTEM_MANAGER;
    }

    public ByteBuffer allocateDirect(int capacity) {
        return ByteBuffer.allocateDirect(capacity).order(ByteOrder.nativeOrder());
    }

    OrtNDArray create(OnnxTensor tensor) {
        return new OrtNDArray(this, tensor);
    }

    public OrtNDArray create(Buffer data, Shape shape, DataType dataType) {
        try {
            return new OrtNDArray(this, OrtUtils.toTensor(this.env, data, shape, dataType));
        }
        catch (OrtException e) {
            throw new EngineException((Throwable)e);
        }
    }

    public NDArray create(Shape shape, DataType dataType) {
        throw new UnsupportedOperationException("Not supported for ONNX Runtime");
    }

    public NDArray createCSR(Buffer data, long[] indptr, long[] indices, Shape shape) {
        throw new UnsupportedOperationException("Not supported for ONNX Runtime");
    }

    public NDArray createRowSparse(Buffer data, Shape dataShape, long[] indices, Shape shape) {
        throw new UnsupportedOperationException("Not supported for ONNX Runtime");
    }

    public NDList load(Path path) {
        throw new UnsupportedOperationException("Not supported for ONNX Runtime");
    }

    public NDArray zeros(Shape shape, DataType dataType) {
        throw new UnsupportedOperationException("Not supported for ONNX Runtime");
    }

    public NDArray ones(Shape shape, DataType dataType) {
        throw new UnsupportedOperationException("Not supported for ONNX Runtime");
    }

    public NDArray arange(float start, float stop, float step, DataType dataType) {
        throw new UnsupportedOperationException("Not supported for ONNX Runtime");
    }

    public NDArray eye(int rows, int cols, int k, DataType dataType) {
        throw new UnsupportedOperationException("Not supported for ONNX Runtime");
    }

    public NDArray linspace(float start, float stop, int num, boolean endpoint) {
        throw new UnsupportedOperationException("Not supported for ONNX Runtime");
    }

    public NDArray randomUniform(float low, float high, Shape shape, DataType dataType) {
        throw new UnsupportedOperationException("Not supported for ONNX Runtime");
    }

    public NDArray randomNormal(float loc, float scale, Shape shape, DataType dataType) {
        throw new UnsupportedOperationException("Not supported for ONNX Runtime");
    }

    public NDArray randomMultinomial(int n, NDArray pValues) {
        throw new UnsupportedOperationException("Not supported for ONNX Runtime");
    }

    public NDArray randomMultinomial(int n, NDArray pValues, Shape shape) {
        throw new UnsupportedOperationException("Not supported for ONNX Runtime");
    }

    public OrtNDManager newSubManager() {
        return this.newSubManager(this.device);
    }

    public OrtNDManager newSubManager(Device device) {
        OrtNDManager manager = new OrtNDManager((NDManager)this, device, this.env);
        this.attach(manager.uid, (AutoCloseable)((Object)manager));
        return manager;
    }

    public void invoke(String operation, NDArray[] src, NDArray[] dest, PairList<String, ?> params) {
    }

    public NDList invoke(String operation, NDList src, PairList<String, ?> params) {
        throw new UnsupportedOperationException("Not supported for ONNX Runtime");
    }

    public Engine getEngine() {
        return Engine.getEngine((String)"OnnxRuntime");
    }

    private static final class SystemManager
    extends OrtNDManager {
        SystemManager() {
            super(null, null, OrtEnvironment.getEnvironment());
        }

        public void attach(String resourceId, AutoCloseable resource) {
        }

        public void detach(String resourceId) {
        }

        public void close() {
        }
    }
}

