/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.onnxruntime.engine;

import ai.djl.util.Platform;
import ai.djl.util.Utils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Enumeration;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class LibUtils {
    private static final Logger logger = LoggerFactory.getLogger(LibUtils.class);
    private static final Pattern VERSION_PATTERN = Pattern.compile("(\\d+\\.\\d+\\.\\d+(-\\w)?)(-SNAPSHOT)?(-\\d+)?");
    private static final String LIB_NAME = "onnxruntime4j_jni";
    private static final String NATIVE_LIB_NAME = "onnxruntime";

    private LibUtils() {
    }

    public static void prepareLibrary() {
        Path libPath = LibUtils.findOverrideLibrary();
        libPath = libPath == null ? LibUtils.findNativeLibrary() : libPath.getParent();
        if (libPath == null) {
            throw new IllegalStateException("ONNX Runtime Library now found!");
        }
        String jniPath = libPath.resolve(System.mapLibraryName(LIB_NAME)).toString();
        String nativePath = libPath.resolve(System.mapLibraryName(NATIVE_LIB_NAME)).toString();
        System.setProperty("onnxruntime.native.onnxruntime4j_jni.path", jniPath);
        System.setProperty("onnxruntime.native.onnxruntime.path", nativePath);
        logger.debug("Loading onnxruntime JNI from: {}", (Object)jniPath);
        logger.debug("Loading onnxruntime native library from: {}", (Object)nativePath);
    }

    private static Path findOverrideLibrary() {
        Path path;
        String libPath = System.getenv("ONNXRUNTIME_LIBRARY_PATH");
        if (libPath != null && (path = LibUtils.findLibraryInPath(libPath)) != null) {
            return path;
        }
        libPath = System.getProperty("java.library.path");
        if (libPath != null) {
            return LibUtils.findLibraryInPath(libPath);
        }
        return null;
    }

    private static Path findLibraryInPath(String libPath) {
        String[] paths = libPath.split(File.pathSeparator);
        String mappedLibName = System.mapLibraryName(LIB_NAME);
        for (String path : paths) {
            File p = new File(path);
            if (!p.exists()) continue;
            if (p.isFile() && p.getName().endsWith(mappedLibName)) {
                return p.toPath();
            }
            File file = new File(path, mappedLibName);
            if (!file.exists() || !file.isFile()) continue;
            return file.toPath();
        }
        return null;
    }

    private static synchronized Path findNativeLibrary() {
        Enumeration<URL> urls;
        try {
            urls = Thread.currentThread().getContextClassLoader().getResources("native/lib/onnxruntime.properties");
        }
        catch (IOException e) {
            logger.warn("", (Throwable)e);
            return null;
        }
        if (!urls.hasMoreElements()) {
            logger.debug("onnxruntime.properties not found in class path.");
            return null;
        }
        Platform systemPlatform = Platform.fromSystem();
        try {
            Platform matching = null;
            Platform placeholder = null;
            while (urls.hasMoreElements()) {
                URL url = urls.nextElement();
                Platform platform = Platform.fromUrl((URL)url);
                if (platform.isPlaceholder()) {
                    placeholder = platform;
                    continue;
                }
                if (!platform.matches(systemPlatform)) continue;
                matching = platform;
                break;
            }
            if (matching != null) {
                return LibUtils.copyNativeLibraryFromClasspath(matching);
            }
            if (placeholder != null) {
                try {
                    return LibUtils.downloadOnnxRuntime(placeholder);
                }
                catch (IOException e) {
                    throw new IllegalStateException("Failed to download ONNXRuntime native library", e);
                }
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to read ONNXRuntime native library jar properties", e);
        }
        throw new IllegalStateException("Your ONNXRuntime native library jar does not match your operating system. Make sure the Maven Dependency Classifier matches your system type.");
    }

    private static Path copyNativeLibraryFromClasspath(Platform platform) {
        Path path;
        block21: {
            Path tmp = null;
            String version = platform.getVersion();
            String flavor = platform.getFlavor();
            String classifier = platform.getClassifier();
            try {
                String libName = System.mapLibraryName(NATIVE_LIB_NAME);
                Path cacheDir = LibUtils.getCacheDir();
                logger.debug("Using cache dir: {}", (Object)cacheDir);
                Path dir = cacheDir.resolve(version + flavor + '-' + classifier);
                Path path2 = dir.resolve(libName);
                if (Files.exists(path2, new LinkOption[0])) {
                    Path path22 = dir;
                    return path22;
                }
                Files.createDirectories(cacheDir, new FileAttribute[0]);
                tmp = Files.createTempDirectory(cacheDir, "tmp", new FileAttribute[0]);
                for (String file : platform.getLibraries()) {
                    String libPath = "/native/lib/" + file;
                    try (InputStream is = LibUtils.class.getResourceAsStream(libPath);){
                        Files.copy(is, tmp.resolve(file), StandardCopyOption.REPLACE_EXISTING);
                    }
                }
                Utils.moveQuietly((Path)tmp, (Path)dir);
                path = dir;
                if (tmp == null) break block21;
            }
            catch (IOException e) {
                throw new IllegalStateException("Failed to extract ONNXRuntime native library", e);
            }
            finally {
                if (tmp != null) {
                    Utils.deleteQuietly(tmp);
                }
            }
            Utils.deleteQuietly((Path)tmp);
        }
        return path;
    }

    /*
     * Loose catch block
     */
    private static Path downloadOnnxRuntime(Platform platform) throws IOException {
        String version = platform.getVersion();
        String flavor = platform.getFlavor();
        if (flavor.isEmpty()) {
            flavor = "cpu";
        }
        String classifier = platform.getClassifier();
        String os = platform.getOsPrefix();
        String libName = System.mapLibraryName(NATIVE_LIB_NAME);
        Path cacheDir = LibUtils.getCacheDir();
        logger.debug("Using cache dir: {}", (Object)cacheDir);
        Path dir = cacheDir.resolve(version + flavor + '-' + classifier);
        Path path = dir.resolve(libName);
        if (Files.exists(path, new LinkOption[0])) {
            return dir;
        }
        Files.createDirectories(cacheDir, new FileAttribute[0]);
        Path tmp = Files.createTempDirectory(cacheDir, "tmp", new FileAttribute[0]);
        Matcher matcher = VERSION_PATTERN.matcher(version);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Unexpected version: " + version);
        }
        String link = "https://djl-ai.s3.amazonaws.com/publish/onnxruntime-" + matcher.group(1);
        try {
            try (InputStream is = new URL(link + "/files.txt").openStream();){
                List lines = Utils.readLines((InputStream)is);
                for (String line : lines) {
                    if (!line.startsWith(flavor + '/' + os + '/')) continue;
                    URL url = new URL(link + '/' + line);
                    String fileName = line.substring(line.lastIndexOf(47) + 1, line.length() - 3);
                    logger.info("Downloading {} ...", (Object)fileName);
                    GZIPInputStream fis = new GZIPInputStream(url.openStream());
                    Throwable throwable = null;
                    try {
                        Files.copy(fis, tmp.resolve(fileName), StandardCopyOption.REPLACE_EXISTING);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (fis == null) continue;
                        if (throwable != null) {
                            try {
                                ((InputStream)fis).close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        ((InputStream)fis).close();
                    }
                }
                Utils.moveQuietly((Path)tmp, (Path)dir);
                Path path2 = dir;
                return path2;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            if (tmp != null) {
                Utils.deleteQuietly((Path)tmp);
            }
        }
    }

    private static Path getCacheDir() {
        String cacheDir = System.getProperty("ENGINE_CACHE_DIR");
        if ((cacheDir == null || cacheDir.isEmpty()) && ((cacheDir = System.getenv("ENGINE_CACHE_DIR")) == null || cacheDir.isEmpty())) {
            cacheDir = System.getProperty("DJL_CACHE_DIR");
            if ((cacheDir == null || cacheDir.isEmpty()) && ((cacheDir = System.getenv("DJL_CACHE_DIR")) == null || cacheDir.isEmpty())) {
                String userHome = System.getProperty("user.home");
                return Paths.get(userHome, ".djl.ai/onnxruntime");
            }
            return Paths.get(cacheDir, NATIVE_LIB_NAME);
        }
        return Paths.get(cacheDir, ".djl.ai/onnxruntime");
    }
}

