/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.onnxruntime.engine;

import ai.djl.engine.EngineException;
import ai.djl.ndarray.NDArray;
import ai.djl.ndarray.NDArrayAdapter;
import ai.djl.ndarray.NDManager;
import ai.djl.ndarray.types.DataType;
import ai.djl.ndarray.types.Shape;
import ai.djl.onnxruntime.engine.OrtNDManager;
import ai.djl.onnxruntime.engine.OrtUtils;
import ai.onnxruntime.OnnxTensor;
import ai.onnxruntime.OrtException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import java.util.UUID;

public class OrtNDArray
extends NDArrayAdapter {
    private OnnxTensor tensor;

    OrtNDArray(OrtNDManager manager, NDManager alternativeManager, OnnxTensor tensor) {
        super((NDManager)manager, alternativeManager, null, null, UUID.randomUUID().toString());
        this.tensor = tensor;
        manager.attachInternal(this.uid, (AutoCloseable)((Object)this));
    }

    OnnxTensor getTensor() {
        return this.tensor;
    }

    public DataType getDataType() {
        if (this.dataType == null) {
            this.dataType = OrtUtils.toDataType(this.tensor.getInfo().type);
        }
        return this.dataType;
    }

    public Shape getShape() {
        if (this.shape == null) {
            this.shape = new Shape(this.tensor.getInfo().getShape());
        }
        return this.shape;
    }

    public void intern(NDArray replaced) {
        this.tensor.close();
        this.tensor = ((OrtNDArray)replaced).tensor;
    }

    public void detach() {
        this.manager.detachInternal(this.getUid());
        this.manager = OrtNDManager.getSystemManager();
    }

    public String[] toStringArray(Charset charset) {
        try {
            Object obj = this.tensor.getValue();
            if (obj instanceof String) {
                return new String[]{(String)obj};
            }
            return (String[])obj;
        }
        catch (OrtException e) {
            throw new EngineException((Throwable)e);
        }
    }

    public ByteBuffer toByteBuffer() {
        if (this.getDataType() == DataType.STRING) {
            throw new IllegalArgumentException("Please use toStringArray() for String NDArray.");
        }
        return this.tensor.getByteBuffer().order(ByteOrder.nativeOrder());
    }

    public void close() {
        if (!this.isClosed) {
            this.tensor.close();
            super.close();
        }
    }
}

