/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.onnxruntime.engine;

import ai.djl.BaseModel;
import ai.djl.Device;
import ai.djl.MalformedModelException;
import ai.djl.ndarray.NDManager;
import ai.djl.ndarray.types.DataType;
import ai.djl.onnxruntime.engine.OrtNDManager;
import ai.djl.onnxruntime.engine.OrtSymbolBlock;
import ai.djl.util.Utils;
import ai.onnxruntime.OrtEnvironment;
import ai.onnxruntime.OrtException;
import ai.onnxruntime.OrtSession;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;

public class OrtModel
extends BaseModel {
    private OrtEnvironment env;

    OrtModel(String name, NDManager manager, OrtEnvironment env) {
        super(name);
        this.manager = manager;
        this.manager.setName("ortModel");
        this.env = env;
        this.dataType = DataType.FLOAT32;
    }

    public void load(Path modelPath, String prefix, Map<String, ?> options) throws IOException, MalformedModelException {
        this.setModelDir(modelPath);
        if (this.block != null) {
            throw new UnsupportedOperationException("ONNX Runtime does not support dynamic blocks");
        }
        Path modelFile = this.findModelFile(prefix);
        if (modelFile == null && (modelFile = this.findModelFile(this.modelDir.toFile().getName())) == null) {
            throw new FileNotFoundException(".onnx file not found in: " + modelPath);
        }
        try {
            OrtSession session;
            Device device = this.manager.getDevice();
            if (device.isGpu()) {
                OrtSession.SessionOptions sessionOptions = new OrtSession.SessionOptions();
                sessionOptions.addCUDA(this.manager.getDevice().getDeviceId());
                session = this.env.createSession(modelFile.toString(), sessionOptions);
            } else {
                session = this.env.createSession(modelFile.toString());
            }
            this.block = new OrtSymbolBlock(session, (OrtNDManager)this.manager);
        }
        catch (OrtException e) {
            throw new MalformedModelException("ONNX Model cannot be loaded", (Throwable)e);
        }
    }

    public void load(InputStream is, Map<String, ?> options) throws IOException, MalformedModelException {
        if (this.block != null) {
            throw new UnsupportedOperationException("ONNX Runtime does not support dynamic blocks");
        }
        this.modelDir = Files.createTempDirectory("ort-model", new FileAttribute[0]);
        this.modelDir.toFile().deleteOnExit();
        try {
            OrtSession session;
            byte[] buf = Utils.toByteArray((InputStream)is);
            Device device = this.manager.getDevice();
            if (device.isGpu()) {
                OrtSession.SessionOptions sessionOptions = new OrtSession.SessionOptions();
                sessionOptions.addCUDA(this.manager.getDevice().getDeviceId());
                session = this.env.createSession(buf, sessionOptions);
            } else {
                session = this.env.createSession(buf);
            }
            this.block = new OrtSymbolBlock(session, (OrtNDManager)this.manager);
        }
        catch (OrtException e) {
            throw new MalformedModelException("ONNX Model cannot be loaded", (Throwable)e);
        }
    }

    private Path findModelFile(String prefix) {
        Path modelFile;
        if (Files.isRegularFile(this.modelDir, new LinkOption[0])) {
            Path file = this.modelDir;
            this.modelDir = this.modelDir.getParent();
            String fileName = file.toFile().getName();
            this.modelName = fileName.endsWith(".onnx") ? fileName.substring(0, fileName.length() - 5) : fileName;
            return file;
        }
        if (prefix == null) {
            prefix = this.modelName;
        }
        if (Files.notExists(modelFile = this.modelDir.resolve(prefix), new LinkOption[0]) || !Files.isRegularFile(modelFile, new LinkOption[0])) {
            if (prefix.endsWith(".onnx")) {
                return null;
            }
            modelFile = this.modelDir.resolve(prefix + ".onnx");
            if (Files.notExists(modelFile, new LinkOption[0]) || !Files.isRegularFile(modelFile, new LinkOption[0])) {
                return null;
            }
        }
        return modelFile;
    }
}

