/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.onnxruntime.engine;

import ai.djl.Device;
import ai.djl.engine.EngineException;
import ai.djl.ndarray.NDArrayAdapter;
import ai.djl.ndarray.NDManager;
import ai.djl.ndarray.NDResource;
import ai.djl.ndarray.types.DataType;
import ai.djl.ndarray.types.Shape;
import ai.djl.onnxruntime.engine.OrtNDManager;
import ai.djl.onnxruntime.engine.OrtUtils;
import ai.onnxruntime.OnnxTensor;
import ai.onnxruntime.OrtException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.UUID;

public class OrtNDArray
implements NDArrayAdapter {
    private OrtNDManager manager;
    private OnnxTensor tensor;
    private Shape shape;
    private DataType dataType;
    private String name;
    private boolean isClosed;
    private String uid;

    OrtNDArray(OrtNDManager manager, OnnxTensor tensor) {
        this.manager = manager;
        this.tensor = tensor;
        this.uid = UUID.randomUUID().toString();
        manager.attachInternal(this.uid, (AutoCloseable)((Object)this));
    }

    OnnxTensor getTensor() {
        return this.tensor;
    }

    public NDManager getManager() {
        return this.manager;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getUid() {
        return this.uid;
    }

    public DataType getDataType() {
        if (this.dataType == null) {
            this.dataType = OrtUtils.toDataType(this.tensor.getInfo().type);
        }
        return this.dataType;
    }

    public Device getDevice() {
        return Device.cpu();
    }

    public Shape getShape() {
        if (this.shape == null) {
            this.shape = new Shape(this.tensor.getInfo().getShape());
        }
        return this.shape;
    }

    public void attach(NDManager manager) {
        this.detach();
        this.manager = (OrtNDManager)manager;
        manager.attachInternal(this.getUid(), (AutoCloseable)((Object)this));
    }

    public void tempAttach(NDManager manager) {
        this.detach();
        OrtNDManager original = this.manager;
        this.manager = (OrtNDManager)manager;
        manager.tempAttachInternal((NDManager)original, this.getUid(), (NDResource)this);
    }

    public void detach() {
        this.manager.detachInternal(this.getUid());
        this.manager = OrtNDManager.getSystemManager();
    }

    public String[] toStringArray() {
        try {
            return (String[])this.tensor.getValue();
        }
        catch (OrtException e) {
            throw new EngineException((Throwable)e);
        }
    }

    public ByteBuffer toByteBuffer() {
        return this.tensor.getByteBuffer().order(ByteOrder.nativeOrder());
    }

    public String toString() {
        if (this.isClosed) {
            return "This array is already closed";
        }
        String arrStr = this.getDataType() == DataType.STRING ? Arrays.toString(this.toStringArray()) : Arrays.toString(this.toArray());
        return "ND: " + this.getShape() + ' ' + this.getDevice() + ' ' + this.getDataType() + '\n' + arrStr;
    }

    public void close() {
        this.tensor.close();
        this.isClosed = true;
    }
}

