/*
 * Decompiled with CFR 0.152.
 */
package ai.onnxruntime;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;

final class OnnxRuntime {
    private static final Logger logger = Logger.getLogger(OnnxRuntime.class.getName());
    private static final int ORT_API_VERSION_1 = 1;
    private static final int ORT_API_VERSION_2 = 2;
    private static final int ORT_API_VERSION_3 = 3;
    static final String ONNXRUNTIME_LIBRARY_NAME = "onnxruntime";
    static final String ONNXRUNTIME_JNI_LIBRARY_NAME = "onnxruntime4j_jni";
    private static final String OS_ARCH_STR = OnnxRuntime.initOsArch();
    private static boolean loaded = false;
    static long ortApiHandle;

    private OnnxRuntime() {
    }

    private static String initOsArch() {
        String detectedOS = null;
        String os = System.getProperty("os.name", "generic").toLowerCase(Locale.ENGLISH);
        detectedOS = os.contains("mac") || os.contains("darwin") ? "osx" : (os.contains("win") ? "win" : (os.contains("nux") ? "linux" : "android"));
        String detectedArch = null;
        String arch = System.getProperty("os.arch", "generic").toLowerCase(Locale.ENGLISH);
        if (arch.indexOf("amd64") == 0) {
            detectedArch = "x64";
        } else if (arch.indexOf("x86") == 0) {
            detectedArch = "x86";
        } else {
            throw new IllegalStateException("Unsupported arch:" + arch);
        }
        return detectedOS + '-' + detectedArch;
    }

    static synchronized void init() throws IOException {
        if (loaded) {
            return;
        }
        Path tempDirectory = OnnxRuntime.isAndroid() ? null : Files.createTempDirectory("onnxruntime-java", new FileAttribute[0]);
        try {
            OnnxRuntime.load(tempDirectory, ONNXRUNTIME_LIBRARY_NAME);
            OnnxRuntime.load(tempDirectory, ONNXRUNTIME_JNI_LIBRARY_NAME);
            ortApiHandle = OnnxRuntime.initialiseAPIBase(3);
            loaded = true;
        }
        finally {
            if (!OnnxRuntime.isAndroid()) {
                OnnxRuntime.cleanUp(tempDirectory.toFile());
            }
        }
    }

    private static void cleanUp(File file) {
        if (!file.exists()) {
            return;
        }
        logger.log(Level.FINE, "Deleting " + file);
        if (!file.delete()) {
            logger.log(Level.FINE, "Deleting " + file + " on exit");
            file.deleteOnExit();
        }
    }

    static boolean isAndroid() {
        try {
            Class.forName("android.app.Activity");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void load(Path tempDirectory, String library) throws IOException {
        block33: {
            if (OnnxRuntime.isAndroid()) {
                System.loadLibrary(ONNXRUNTIME_JNI_LIBRARY_NAME);
                return;
            }
            String skip = System.getProperty("onnxruntime.native." + library + ".skip");
            if (Boolean.TRUE.toString().equalsIgnoreCase(skip)) {
                logger.log(Level.FINE, "Skipping load of native library '" + library + "'");
                return;
            }
            String libraryPathProperty = System.getProperty("onnxruntime.native." + library + ".path");
            if (libraryPathProperty != null) {
                logger.log(Level.FINE, "Attempting to load native library '" + library + "' from specified path: " + libraryPathProperty);
                File libraryFile = new File(libraryPathProperty);
                String libraryFilePath = libraryFile.getAbsolutePath();
                if (!libraryFile.exists()) {
                    throw new IOException("Native library '" + library + "' not found at " + libraryFilePath);
                }
                System.load(libraryFilePath);
                logger.log(Level.FINE, "Loaded native library '" + library + "' from specified path");
                return;
            }
            String libraryFileName = System.mapLibraryName(library).replace("jnilib", "dylib");
            String resourcePath = "/ai/onnxruntime/native/" + OS_ARCH_STR + '/' + libraryFileName;
            File tempFile = tempDirectory.resolve(libraryFileName).toFile();
            try (InputStream is = OnnxRuntime.class.getResourceAsStream(resourcePath);){
                if (is == null) {
                    logger.log(Level.FINE, "Attempting to load native library '" + library + "' from library path");
                    System.loadLibrary(library);
                    logger.log(Level.FINE, "Loaded native library '" + library + "' from library path");
                    break block33;
                }
                logger.log(Level.FINE, "Attempting to load native library '" + library + "' from resource path " + resourcePath + " copying to " + tempFile);
                byte[] buffer = new byte[1024];
                try (FileOutputStream os = new FileOutputStream(tempFile);){
                    int readBytes;
                    while ((readBytes = is.read(buffer)) != -1) {
                        os.write(buffer, 0, readBytes);
                    }
                }
                System.load(tempFile.getAbsolutePath());
                logger.log(Level.FINE, "Loaded native library '" + library + "' from resource path");
            }
            finally {
                OnnxRuntime.cleanUp(tempFile);
            }
        }
    }

    private static native long initialiseAPIBase(int var0);
}

