/*
 * Decompiled with CFR 0.152.
 */
package ai.onnxruntime;

import ai.onnxruntime.TensorInfo;

public enum OnnxJavaType {
    FLOAT(1, Float.TYPE, 4),
    DOUBLE(2, Double.TYPE, 8),
    INT8(3, Byte.TYPE, 1),
    INT16(4, Short.TYPE, 2),
    INT32(5, Integer.TYPE, 4),
    INT64(6, Long.TYPE, 8),
    BOOL(7, Boolean.TYPE, 1),
    STRING(8, String.class, 4),
    UNKNOWN(0, Object.class, 0);

    private static final OnnxJavaType[] values;
    public final int value;
    public final Class<?> clazz;
    public final int size;

    private OnnxJavaType(int value, Class<?> clazz, int size) {
        this.value = value;
        this.clazz = clazz;
        this.size = size;
    }

    public static OnnxJavaType mapFromInt(int value) {
        if (value > 0 && value < values.length) {
            return values[value];
        }
        return UNKNOWN;
    }

    public static OnnxJavaType mapFromOnnxTensorType(TensorInfo.OnnxTensorType onnxValue) {
        switch (onnxValue) {
            case ONNX_TENSOR_ELEMENT_DATA_TYPE_UINT8: 
            case ONNX_TENSOR_ELEMENT_DATA_TYPE_INT8: {
                return INT8;
            }
            case ONNX_TENSOR_ELEMENT_DATA_TYPE_UINT16: 
            case ONNX_TENSOR_ELEMENT_DATA_TYPE_INT16: {
                return INT16;
            }
            case ONNX_TENSOR_ELEMENT_DATA_TYPE_UINT32: 
            case ONNX_TENSOR_ELEMENT_DATA_TYPE_INT32: {
                return INT32;
            }
            case ONNX_TENSOR_ELEMENT_DATA_TYPE_UINT64: 
            case ONNX_TENSOR_ELEMENT_DATA_TYPE_INT64: {
                return INT64;
            }
            case ONNX_TENSOR_ELEMENT_DATA_TYPE_FLOAT16: 
            case ONNX_TENSOR_ELEMENT_DATA_TYPE_FLOAT: {
                return FLOAT;
            }
            case ONNX_TENSOR_ELEMENT_DATA_TYPE_DOUBLE: {
                return DOUBLE;
            }
            case ONNX_TENSOR_ELEMENT_DATA_TYPE_STRING: {
                return STRING;
            }
            case ONNX_TENSOR_ELEMENT_DATA_TYPE_BOOL: {
                return BOOL;
            }
        }
        return UNKNOWN;
    }

    public static OnnxJavaType mapFromClass(Class<?> clazz) {
        if (clazz.equals(Byte.TYPE) || clazz.equals(Byte.class)) {
            return INT8;
        }
        if (clazz.equals(Short.TYPE) || clazz.equals(Short.class)) {
            return INT16;
        }
        if (clazz.equals(Integer.TYPE) || clazz.equals(Integer.class)) {
            return INT32;
        }
        if (clazz.equals(Long.TYPE) || clazz.equals(Long.class)) {
            return INT64;
        }
        if (clazz.equals(Float.TYPE) || clazz.equals(Float.class)) {
            return FLOAT;
        }
        if (clazz.equals(Double.TYPE) || clazz.equals(Double.class)) {
            return DOUBLE;
        }
        if (clazz.equals(Boolean.TYPE) || clazz.equals(Boolean.class)) {
            return BOOL;
        }
        if (clazz.equals(String.class)) {
            return STRING;
        }
        return UNKNOWN;
    }

    static {
        values = new OnnxJavaType[9];
        OnnxJavaType[] onnxJavaTypeArray = OnnxJavaType.values();
        int n = onnxJavaTypeArray.length;
        for (int i = 0; i < n; ++i) {
            OnnxJavaType ot;
            OnnxJavaType.values[ot.value] = ot = onnxJavaTypeArray[i];
        }
    }
}

