/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.mxnet.engine;

import ai.djl.Device;

public final class MxDeviceType {
    private static final String CPU_PINNED = "cpu_pinned";

    private MxDeviceType() {
    }

    public static int toDeviceType(Device device) {
        String deviceType = device.getDeviceType();
        if ("cpu".equals(deviceType)) {
            return 1;
        }
        if ("gpu".equals(deviceType)) {
            return 2;
        }
        if (CPU_PINNED.equals(deviceType)) {
            return 3;
        }
        throw new IllegalArgumentException("Unsupported device: " + device);
    }

    public static String fromDeviceType(int deviceType) {
        switch (deviceType) {
            case 1: 
            case 3: {
                return "cpu";
            }
            case 2: {
                return "gpu";
            }
        }
        throw new IllegalArgumentException("Unsupported deviceType: " + deviceType);
    }
}

