/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.huggingface.tokenizers;

import ai.djl.huggingface.tokenizers.TokenizerConfig;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.Reader;
import java.io.StringReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PadTokenResolver {
    private static final Logger logger = LoggerFactory.getLogger(PadTokenResolver.class);

    private PadTokenResolver() {
        throw new IllegalStateException("Utility class");
    }

    public static PadInfo extractPadInfo(String tokenizerJson, TokenizerConfig config) {
        try {
            JsonObject padding;
            JsonObject tokenizer = JsonParser.parseReader((Reader)new StringReader(tokenizerJson)).getAsJsonObject();
            if (tokenizer.has("padding") && !tokenizer.get("padding").isJsonNull() && (padding = tokenizer.getAsJsonObject("padding")) != null && padding.has("pad_token") && padding.has("pad_id")) {
                String padToken = padding.get("pad_token").getAsString();
                int padId = padding.get("pad_id").getAsInt();
                return new PadInfo(padToken, padId);
            }
            if (config != null && config.getPadToken() != null) {
                JsonObject vocab;
                JsonElement element;
                JsonObject model;
                String padToken = config.getPadToken();
                if (tokenizer.has("added_tokens")) {
                    JsonArray added = tokenizer.getAsJsonArray("added_tokens");
                    for (JsonElement el : added) {
                        JsonObject item = el.getAsJsonObject();
                        if (!padToken.equals(item.get("content").getAsString())) continue;
                        int id = item.get("id").getAsInt();
                        return new PadInfo(padToken, id);
                    }
                }
                if (tokenizer.has("model") && (model = tokenizer.getAsJsonObject("model")).has("vocab") && (element = (vocab = model.getAsJsonObject("vocab")).get(padToken)) != null && element.isJsonPrimitive()) {
                    int id = element.getAsInt();
                    return new PadInfo(padToken, id);
                }
                logger.warn("pad_token '{}' was found in config, but not in tokenizer.json added_tokens or vocab", (Object)padToken);
            }
        }
        catch (Exception e) {
            logger.warn("Failed to parse pad_token from tokenizer.json", (Throwable)e);
        }
        return null;
    }

    public static class PadInfo {
        private final String padToken;
        private final int padId;

        public PadInfo(String padToken, int padId) {
            this.padToken = padToken;
            this.padId = padId;
        }

        public String getPadToken() {
            return this.padToken;
        }

        public int getPadId() {
            return this.padId;
        }
    }
}

