/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.fasttext.engine;

import ai.djl.MalformedModelException;
import ai.djl.Model;
import ai.djl.fasttext.dataset.FtDataset;
import ai.djl.fasttext.engine.FtBlockPlaceholder;
import ai.djl.fasttext.engine.FtNDManagerPlaceholder;
import ai.djl.fasttext.engine.FtTrainingConfig;
import ai.djl.inference.Predictor;
import ai.djl.ndarray.NDManager;
import ai.djl.ndarray.types.DataType;
import ai.djl.ndarray.types.Shape;
import ai.djl.nn.Block;
import ai.djl.training.Trainer;
import ai.djl.training.TrainingConfig;
import ai.djl.training.TrainingResult;
import ai.djl.translate.Translator;
import ai.djl.util.PairList;
import com.github.jfasttext.FastTextWrapper;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.bytedeco.javacpp.PointerPointer;

public class FtModel
implements Model {
    FastTextWrapper.FastTextApi fta;
    private Path modelDir;
    private String modelName;
    private Map<String, String> properties;

    FtModel(String name) {
        this.modelName = name;
        this.fta = new FastTextWrapper.FastTextApi();
        this.properties = new ConcurrentHashMap<String, String>();
    }

    public void load(Path modelPath, String prefix, Map<String, Object> options) throws IOException, MalformedModelException {
        Path modelFile;
        if (Files.notExists(modelPath, new LinkOption[0])) {
            throw new FileNotFoundException("Model directory doesn't exist: " + modelPath.toAbsolutePath());
        }
        this.modelDir = modelPath.toAbsolutePath();
        if (prefix == null) {
            prefix = this.modelName;
        }
        if ((modelFile = this.findModelFile(prefix)) == null && (modelFile = this.findModelFile(this.modelDir.toFile().getName())) == null) {
            throw new FileNotFoundException("No .ftz or .bin file found in : " + modelPath);
        }
        String modelFilePath = modelFile.toString();
        if (!this.fta.checkModel(modelFilePath)) {
            throw new MalformedModelException("Malformed FastText model file:" + modelFilePath);
        }
        this.fta.loadModel(modelFilePath);
        this.properties.put("model-type", this.fta.getModelName().getString());
    }

    private Path findModelFile(String prefix) {
        Path modelFile = this.modelDir.resolve(prefix);
        if (Files.notExists(modelFile, new LinkOption[0]) || !Files.isRegularFile(modelFile, new LinkOption[0])) {
            if (prefix.endsWith(".ftz") || prefix.endsWith(".bin")) {
                return null;
            }
            modelFile = this.modelDir.resolve(prefix + ".ftz");
            if (!(!Files.notExists(modelFile, new LinkOption[0]) && Files.isRegularFile(modelFile, new LinkOption[0]) || !Files.notExists(modelFile = this.modelDir.resolve(prefix + ".bin"), new LinkOption[0]) && Files.isRegularFile(modelFile, new LinkOption[0]))) {
                return null;
            }
        }
        return modelFile;
    }

    public TrainingResult fit(FtTrainingConfig config, FtDataset trainingSet, FtDataset validateSet) throws IOException {
        Path outputDir = config.getOutputDir();
        if (Files.notExists(outputDir, new LinkOption[0])) {
            Files.createDirectory(outputDir, new FileAttribute[0]);
        }
        String fitModelName = config.getModelName();
        Path modelFile = outputDir.resolve(fitModelName).toAbsolutePath();
        String[] args = config.toCommand(trainingSet.getInputFile().toString());
        this.fta.runCmd(args.length, new PointerPointer(args));
        this.setModelFile(modelFile);
        TrainingResult result = new TrainingResult();
        int epoch = config.getEpoch();
        if (epoch <= 0) {
            epoch = 5;
        }
        result.setEpoch(epoch);
        return result;
    }

    public void save(Path modelDir, String newModelName) {
    }

    public Block getBlock() {
        return FtBlockPlaceholder.PLACEHOLDER;
    }

    public void setBlock(Block block) {
        throw new UnsupportedOperationException("Fasttext doesn't support setting the Block.");
    }

    public String getName() {
        return this.modelName;
    }

    public Trainer newTrainer(TrainingConfig trainingConfig) {
        throw new UnsupportedOperationException("FastText only supports training using FtModel.fit");
    }

    public <I, O> Predictor<I, O> newPredictor(Translator<I, O> translator) {
        return new Predictor((Model)this, translator, false);
    }

    public void setDataType(DataType dataType) {
    }

    public DataType getDataType() {
        return DataType.UNKNOWN;
    }

    public void cast(DataType dataType) {
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    public PairList<String, Shape> describeInput() {
        return null;
    }

    public PairList<String, Shape> describeOutput() {
        return null;
    }

    public String[] getArtifactNames() {
        return null;
    }

    public <T> T getArtifact(String name, Function<InputStream, T> function) {
        return null;
    }

    public URL getArtifact(String artifactName) {
        return null;
    }

    public InputStream getArtifactAsStream(String name) {
        return null;
    }

    public NDManager getNDManager() {
        return FtNDManagerPlaceholder.PLACEHOLDER;
    }

    public void setProperty(String key, String value) {
        this.properties.put(key, value);
    }

    public String getProperty(String key) {
        return this.properties.get(key);
    }

    void setModelFile(Path modelFile) {
        this.modelDir = modelFile;
    }

    public void close() {
        this.fta.unloadModel();
        this.fta.close();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(200);
        sb.append("Model (\n\tName: ").append(this.modelName);
        if (this.modelDir != null) {
            sb.append("\n\tModel location: ").append(this.modelDir.toAbsolutePath());
        }
        for (Map.Entry<String, String> entry : this.properties.entrySet()) {
            sb.append("\n\t").append(entry.getKey()).append(": ").append(entry.getValue());
        }
        sb.append("\n)");
        return sb.toString();
    }
}

