/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.fasttext.jni;

import ai.djl.fasttext.jni.FastTextLibrary;
import ai.djl.fasttext.jni.LibUtils;
import ai.djl.modality.Classifications;
import ai.djl.util.NativeResource;
import java.util.ArrayList;

public final class FtWrapper
extends NativeResource<Long> {
    private static RuntimeException libraryStatus;

    private FtWrapper() {
        super((Object)FastTextLibrary.LIB.createFastText());
    }

    public static FtWrapper newInstance() {
        if (libraryStatus != null) {
            throw libraryStatus;
        }
        return new FtWrapper();
    }

    public void loadModel(String modelFilePath) {
        FastTextLibrary.LIB.loadModel((Long)this.getHandle(), modelFilePath);
    }

    public boolean checkModel(String modelFilePath) {
        return FastTextLibrary.LIB.checkModel(modelFilePath);
    }

    public void unloadModel() {
        FastTextLibrary.LIB.unloadModel((Long)this.getHandle());
    }

    public String getModelType() {
        return FastTextLibrary.LIB.getModelType((Long)this.getHandle());
    }

    public Classifications predictProba(String text, int topK, String labelPrefix) {
        String[] labels = new String[topK];
        float[] probs = new float[topK];
        int size = FastTextLibrary.LIB.predictProba((Long)this.getHandle(), text, topK, labels, probs);
        ArrayList<String> classes = new ArrayList<String>(size);
        ArrayList<Double> probabilities = new ArrayList<Double>(size);
        for (int i = 0; i < size; ++i) {
            String label = labels[i];
            if (label.startsWith(labelPrefix)) {
                label = label.substring(labelPrefix.length());
            }
            classes.add(label);
            probabilities.add(Double.valueOf(probs[i]));
        }
        return new Classifications(classes, probabilities);
    }

    public float[] getDataVector(String word) {
        return FastTextLibrary.LIB.getWordVector((Long)this.getHandle(), word);
    }

    public void runCmd(String[] args) {
        FastTextLibrary.LIB.runCmd(args);
    }

    public void close() {
        Long pointer = this.handle.getAndSet(null);
        if (pointer != null) {
            FastTextLibrary.LIB.freeFastText(pointer);
        }
    }

    static {
        try {
            LibUtils.loadLibrary();
        }
        catch (RuntimeException e) {
            libraryStatus = e;
        }
    }
}

