/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.fasttext.zoo.nlp.textclassification;

import ai.djl.Application;
import ai.djl.MalformedModelException;
import ai.djl.Model;
import ai.djl.fasttext.FtModel;
import ai.djl.fasttext.zoo.FtModelZoo;
import ai.djl.repository.Artifact;
import ai.djl.repository.MRL;
import ai.djl.repository.Repository;
import ai.djl.repository.zoo.BaseModelLoader;
import ai.djl.repository.zoo.Criteria;
import ai.djl.repository.zoo.ModelNotFoundException;
import ai.djl.repository.zoo.ModelZoo;
import ai.djl.repository.zoo.ZooModel;
import ai.djl.util.Progress;
import java.io.IOException;
import java.nio.file.Path;

public class TextClassificationModelLoader
extends BaseModelLoader {
    private static final Application APPLICATION = Application.NLP.TEXT_CLASSIFICATION;
    private static final String GROUP_ID = "ai.djl.fasttext";
    private static final String ARTIFACT_ID = "cooking_stackexchange";
    private static final String VERSION = "0.0.1";

    public TextClassificationModelLoader(Repository repository) {
        super(repository, MRL.model((Application)APPLICATION, (String)GROUP_ID, (String)ARTIFACT_ID), VERSION, (ModelZoo)new FtModelZoo());
    }

    public <I, O> ZooModel<I, O> loadModel(Criteria<I, O> criteria) throws ModelNotFoundException, IOException, MalformedModelException {
        String modelName;
        Artifact artifact = this.resource.match(criteria.getFilters());
        if (artifact == null) {
            throw new ModelNotFoundException("No matching filter found");
        }
        Progress progress = criteria.getProgress();
        this.resource.prepare(artifact, progress);
        if (progress != null) {
            progress.reset("Loading", 2L);
            progress.update(1L);
        }
        if ((modelName = criteria.getModelName()) == null) {
            modelName = artifact.getName();
        }
        FtModel model = new FtModel(modelName);
        Path modelPath = this.resource.getRepository().getResourceDirectory(artifact);
        model.load(modelPath);
        return new ZooModel((Model)model, null);
    }
}

