/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.basicdataset;

import ai.djl.Application;
import ai.djl.basicdataset.TextDataset;
import ai.djl.modality.nlp.embedding.EmbeddingException;
import ai.djl.ndarray.NDArray;
import ai.djl.ndarray.NDList;
import ai.djl.ndarray.NDManager;
import ai.djl.ndarray.types.DataType;
import ai.djl.repository.Artifact;
import ai.djl.repository.MRL;
import ai.djl.repository.Resource;
import ai.djl.training.dataset.Record;
import ai.djl.util.Progress;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;

public class StanfordMovieReview
extends TextDataset {
    private static final String VERSION = "1.0";
    private static final String ARTIFACT_ID = "stanford-movie-review";
    private List<Boolean> reviewSentiments;
    private List<Integer> reviewImdbScore;

    protected StanfordMovieReview(Builder builder) {
        super(builder);
        this.usage = builder.usage;
        MRL mrl = MRL.dataset((Application)Application.NLP.SENTIMENT_ANALYSIS, (String)builder.groupId, (String)builder.artifactId);
        this.resource = new Resource(builder.repository, mrl, VERSION);
    }

    public static Builder builder() {
        return new Builder();
    }

    public void prepare(Progress progress) throws IOException, EmbeddingException {
        Path usagePath;
        if (this.prepared) {
            return;
        }
        Artifact artifact = this.resource.getDefaultArtifact();
        this.resource.prepare(artifact, progress);
        Path cacheDir = this.resource.getRepository().getCacheDirectory();
        URI resourceUri = artifact.getResourceUri();
        Path root = cacheDir.resolve(resourceUri.getPath()).resolve("aclImdb").resolve("aclImdb");
        switch (this.usage) {
            case TRAIN: {
                usagePath = Paths.get("train", new String[0]);
                break;
            }
            case TEST: {
                usagePath = Paths.get("test", new String[0]);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Validation data not available.");
            }
        }
        usagePath = root.resolve(usagePath);
        ArrayList<String> reviewTexts = new ArrayList<String>();
        this.reviewSentiments = new ArrayList<Boolean>();
        this.reviewImdbScore = new ArrayList<Integer>();
        this.prepareDataSentiment(usagePath.resolve("pos"), true, reviewTexts);
        this.prepareDataSentiment(usagePath.resolve("neg"), false, reviewTexts);
        this.preprocess(reviewTexts, true);
        this.prepared = true;
    }

    private void prepareDataSentiment(Path path, boolean sentiment, List<String> reviewTexts) throws IOException {
        File dir = path.toFile();
        if (!dir.exists()) {
            throw new IllegalArgumentException("Could not find Stanford Movie Review dataset");
        }
        File[] files = dir.listFiles(File::isFile);
        if (files == null) {
            throw new IllegalArgumentException("Could not find files in Stanford Movie Review dataset");
        }
        for (File reviewFile : files) {
            Path reviewPath = reviewFile.toPath();
            String reviewText = new String(Files.readAllBytes(reviewPath), StandardCharsets.UTF_8);
            String[] splitName = reviewFile.getName().split("\\.")[0].split("_");
            reviewTexts.add(reviewText);
            this.reviewSentiments.add(sentiment);
            this.reviewImdbScore.add(Integer.parseInt(splitName[1]));
        }
    }

    protected Record get(NDManager manager, long index) {
        NDList data = new NDList();
        data.add((Object)this.sourceTextData.getEmbedding(manager, index));
        NDList label = new NDList(new NDArray[]{manager.create(this.reviewSentiments.get(Math.toIntExact(index)).booleanValue()).toType(DataType.INT32, false)});
        return new Record(data, label);
    }

    protected long availableSize() {
        return this.sourceTextData.getSize();
    }

    public static class Builder
    extends TextDataset.Builder<Builder> {
        public Builder() {
            this.artifactId = StanfordMovieReview.ARTIFACT_ID;
        }

        protected Builder self() {
            return this;
        }

        public StanfordMovieReview build() {
            return new StanfordMovieReview(this);
        }
    }
}

