/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.basicdataset;

import ai.djl.Application;
import ai.djl.basicdataset.BasicDatasets;
import ai.djl.modality.cv.Image;
import ai.djl.modality.cv.ImageFactory;
import ai.djl.modality.cv.transform.ToTensor;
import ai.djl.ndarray.NDArray;
import ai.djl.ndarray.NDList;
import ai.djl.ndarray.NDManager;
import ai.djl.repository.Artifact;
import ai.djl.repository.MRL;
import ai.djl.repository.Repository;
import ai.djl.repository.dataset.ZooDataset;
import ai.djl.training.dataset.Dataset;
import ai.djl.training.dataset.RandomAccessDataset;
import ai.djl.training.dataset.Record;
import ai.djl.translate.Pipeline;
import ai.djl.translate.Transform;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;

public class CaptchaDataset
extends RandomAccessDataset
implements ZooDataset {
    public static final int IMAGE_WIDTH = 160;
    public static final int IMAGE_HEIGHT = 60;
    public static final int CAPTCHA_LENGTH = 6;
    public static final int CAPTCHA_OPTIONS = 11;
    private static final String ARTIFACT_ID = "captcha";
    private Repository repository;
    private Artifact artifact;
    private Dataset.Usage usage;
    private boolean prepared;
    private List<String> items;

    public CaptchaDataset(Builder builder) {
        super((RandomAccessDataset.BaseBuilder)builder);
        this.repository = builder.repository;
        this.artifact = builder.artifact;
        this.usage = builder.usage;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Record get(NDManager manager, long index) throws IOException {
        String item = this.items.get(Math.toIntExact(index));
        Path imagePath = this.repository.getFile(this.getArtifactItem(), this.getUsagePath() + "/" + item + ".jpeg");
        NDArray imageArray = ImageFactory.getInstance().fromFile(imagePath).toNDArray(manager, Image.Flag.GRAYSCALE);
        NDList data = new NDList(new NDArray[]{imageArray});
        NDList labels = new NDList(6);
        char[] labelChars = item.toCharArray();
        for (int i = 0; i < 6; ++i) {
            if (i < item.length()) {
                int labelDigit = Integer.parseInt(Character.toString(labelChars[i]));
                labels.add((Object)manager.create(labelDigit));
                continue;
            }
            labels.add((Object)manager.create(11));
        }
        return new Record(data, labels);
    }

    protected long availableSize() {
        return this.items.size();
    }

    public MRL getMrl() {
        return MRL.dataset((Application)Application.CV.IMAGE_CLASSIFICATION, (String)"ai.djl.basicdataset", (String)ARTIFACT_ID);
    }

    public Repository getRepository() {
        return this.repository;
    }

    public Artifact getArtifact() {
        return this.artifact;
    }

    public Dataset.Usage getUsage() {
        return this.usage;
    }

    public boolean isPrepared() {
        return this.prepared;
    }

    public void setPrepared(boolean prepared) {
        this.prepared = prepared;
    }

    public void useDefaultArtifact() throws IOException {
        this.artifact = this.repository.resolve(this.getMrl(), "1.1", null);
    }

    public void prepareData(Dataset.Usage usage) throws IOException {
        this.items = new ArrayList<String>();
        for (String filenameWithExtension : this.repository.listDirectory(this.getArtifactItem(), this.getUsagePath())) {
            String captchaFilename = filenameWithExtension.substring(0, filenameWithExtension.lastIndexOf(46));
            this.items.add(captchaFilename);
        }
    }

    private Artifact.Item getArtifactItem() {
        return (Artifact.Item)this.artifact.getFiles().get("data");
    }

    private String getUsagePath() {
        switch (this.usage) {
            case TRAIN: {
                return "train";
            }
            case TEST: {
                return "test";
            }
            case VALIDATION: {
                return "validate";
            }
        }
        throw new IllegalArgumentException("Invalid usage");
    }

    public static final class Builder
    extends RandomAccessDataset.BaseBuilder<Builder> {
        Repository repository = BasicDatasets.REPOSITORY;
        Artifact artifact;
        Dataset.Usage usage = Dataset.Usage.TRAIN;

        Builder() {
            this.pipeline = new Pipeline(new Transform[]{new ToTensor()});
        }

        protected Builder self() {
            return this;
        }

        public Builder optRepository(Repository repository) {
            this.repository = repository;
            return this;
        }

        public Builder optArtifact(Artifact artifact) {
            this.artifact = artifact;
            return this;
        }

        public Builder optUsage(Dataset.Usage usage) {
            this.usage = usage;
            return this;
        }

        public CaptchaDataset build() {
            return new CaptchaDataset(this);
        }
    }
}

