/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.basicdataset.cv;

import ai.djl.basicdataset.cv.ImageDataset;
import ai.djl.modality.cv.output.Rectangle;
import ai.djl.ndarray.NDArray;
import ai.djl.ndarray.NDList;
import ai.djl.ndarray.NDManager;
import ai.djl.training.dataset.Record;
import ai.djl.util.Pair;
import ai.djl.util.PairList;
import java.io.IOException;
import java.util.List;

public abstract class ObjectDetectionDataset
extends ImageDataset {
    public ObjectDetectionDataset(ImageDataset.BaseBuilder<?> builder) {
        super(builder);
    }

    public Record get(NDManager manager, long index) throws IOException {
        NDList data = new NDList(new NDArray[]{this.getRecordImage(manager, index)});
        PairList<Long, Rectangle> objects = this.getObjects(index);
        float[][] labelsSplit = new float[objects.size()][5];
        for (int i = 0; i < objects.size(); ++i) {
            Pair obj = objects.get(i);
            labelsSplit[i][0] = ((Long)obj.getKey()).longValue();
            Rectangle location = (Rectangle)obj.getValue();
            labelsSplit[i][1] = (float)location.getX();
            labelsSplit[i][2] = (float)location.getY();
            labelsSplit[i][3] = (float)location.getWidth();
            labelsSplit[i][4] = (float)location.getHeight();
        }
        NDList labels = new NDList(new NDArray[]{manager.create(labelsSplit)});
        return new Record(data, labels);
    }

    public abstract PairList<Long, Rectangle> getObjects(long var1) throws IOException;

    public abstract List<String> getClasses();
}

