/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.basicdataset.nlp;

import ai.djl.Application;
import ai.djl.basicdataset.BasicDatasets;
import ai.djl.ndarray.NDManager;
import ai.djl.repository.Artifact;
import ai.djl.repository.MRL;
import ai.djl.repository.Repository;
import ai.djl.training.dataset.Batch;
import ai.djl.training.dataset.Dataset;
import ai.djl.training.dataset.RawDataset;
import ai.djl.translate.TranslateException;
import ai.djl.util.Progress;
import java.io.IOException;
import java.nio.file.Path;

public class WikiText2
implements RawDataset<Path> {
    private static final String VERSION = "1.0";
    private static final String ARTIFACT_ID = "wikitext-2";
    private Dataset.Usage usage;
    private Path root;
    private MRL mrl;
    private boolean prepared;

    WikiText2(Builder builder) {
        this.usage = builder.usage;
        this.mrl = builder.getMrl();
    }

    public static Builder builder() {
        return new Builder();
    }

    public void prepare(Progress progress) throws IOException {
        String path;
        if (this.prepared) {
            return;
        }
        Artifact artifact = this.mrl.getDefaultArtifact();
        this.mrl.prepare(artifact, progress);
        Artifact.Item item = (Artifact.Item)artifact.getFiles().get(ARTIFACT_ID);
        switch (this.usage) {
            case TRAIN: {
                path = "wikitext-2/wiki.train.tokens";
                break;
            }
            case TEST: {
                path = "wikitext-2/wiki.test.tokens";
                break;
            }
            case VALIDATION: {
                path = "wikitext-2/wiki.valid.tokens";
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported usage type.");
            }
        }
        this.root = this.mrl.getRepository().getFile(item, path).toAbsolutePath();
        this.prepared = true;
    }

    public Iterable<Batch> getData(NDManager manager) throws IOException, TranslateException {
        return null;
    }

    public Path getData() throws IOException {
        this.prepare(null);
        return this.root;
    }

    public static final class Builder {
        Repository repository = BasicDatasets.REPOSITORY;
        String groupId = "ai.djl.basicdataset";
        String artifactId = "wikitext-2";
        Dataset.Usage usage = Dataset.Usage.TRAIN;

        Builder() {
        }

        public Builder optRepository(Repository repository) {
            this.repository = repository;
            return this;
        }

        public Builder optGroupId(String groupId) {
            this.groupId = groupId;
            return this;
        }

        public Builder optArtifactId(String artifactId) {
            if (artifactId.contains(":")) {
                String[] tokens = artifactId.split(":");
                this.groupId = tokens[0];
                this.artifactId = tokens[1];
            } else {
                this.artifactId = artifactId;
            }
            return this;
        }

        public Builder optUsage(Dataset.Usage usage) {
            this.usage = usage;
            return this;
        }

        public WikiText2 build() {
            return new WikiText2(this);
        }

        MRL getMrl() {
            return this.repository.dataset(Application.NLP.ANY, this.groupId, this.artifactId, WikiText2.VERSION);
        }
    }
}

