/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.basicdataset;

import ai.djl.basicdataset.AbstractImageFolder;
import ai.djl.basicdataset.ImageFolder;
import ai.djl.repository.dataset.PreparedDataset;
import ai.djl.training.dataset.Dataset;
import ai.djl.util.Progress;
import com.google.gson.Gson;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;

public class ImageNet
extends AbstractImageFolder
implements PreparedDataset {
    private Dataset.Usage usage;
    private boolean prepared;
    private String[] wordNetIds;
    private String[] classNames;
    private String[] classFull;

    ImageNet(Builder builder) {
        super(builder);
        this.usage = builder.usage;
        this.loadSynset();
    }

    public static ImageFolder.Builder builder() {
        return new ImageFolder.Builder();
    }

    public String[] getWordNetIds() {
        return this.wordNetIds;
    }

    public String[] getClassNames() {
        return this.classNames;
    }

    public String[] getClassFull() {
        return this.classFull;
    }

    public void prepare(Progress progress) {
        if (!this.prepared) {
            File root = Paths.get(this.repository.getBaseUri()).resolve(this.getUsagePath(this.usage)).toFile();
            if (progress != null) {
                progress.reset("Preparing", 2L);
                progress.start(0L);
                this.listImages(root, Arrays.asList(this.wordNetIds));
                progress.end();
            } else {
                this.listImages(root, Arrays.asList(this.wordNetIds));
            }
            this.prepared = true;
        }
    }

    private void loadSynset() {
        InputStream classStream = Thread.currentThread().getContextClassLoader().getResourceAsStream("imagenet/classes.json");
        if (classStream == null) {
            throw new AssertionError((Object)"Missing imagenet/classes.json in jar resource");
        }
        String[][] classes = (String[][])new Gson().fromJson((Reader)new InputStreamReader(classStream, StandardCharsets.UTF_8), String[][].class);
        this.wordNetIds = new String[classes.length];
        this.classNames = new String[classes.length];
        this.classFull = new String[classes.length];
        for (int i = 0; i < classes.length; ++i) {
            this.wordNetIds[i] = classes[i][0];
            this.classNames[i] = classes[i][1];
            this.classFull[i] = classes[i][2];
            this.synset.add(this.wordNetIds[i] + ", " + this.classNames[i] + ", " + this.classFull[i]);
        }
    }

    private String getUsagePath(Dataset.Usage usage) {
        switch (usage) {
            case TRAIN: {
                String usagePath = "train";
                return usagePath;
            }
            case VALIDATION: {
                String usagePath = "val";
                return usagePath;
            }
            case TEST: {
                throw new UnsupportedOperationException("Test data not available.");
            }
        }
        throw new UnsupportedOperationException("Data not available.");
    }

    @Override
    protected Path getImagePath(String key) {
        return Paths.get(this.repository.getBaseUri()).resolve(this.getUsagePath(this.usage)).resolve(key);
    }

    public static class Builder
    extends AbstractImageFolder.ImageFolderBuilder<Builder> {
        private Dataset.Usage usage = Dataset.Usage.TRAIN;

        public Builder optUsage(Dataset.Usage usage) {
            this.usage = usage;
            return this;
        }

        public Builder self() {
            return this;
        }

        public ImageNet build() {
            return new ImageNet(this);
        }
    }
}

