/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.basicdataset.cv;

import ai.djl.modality.cv.Image;
import ai.djl.modality.cv.util.NDImageUtils;
import ai.djl.ndarray.NDArray;
import ai.djl.ndarray.NDManager;
import ai.djl.training.dataset.RandomAccessDataset;
import java.io.IOException;
import java.util.Optional;

public abstract class ImageDataset
extends RandomAccessDataset {
    protected Image.Flag flag;

    public ImageDataset(BaseBuilder<?> builder) {
        super(builder);
        this.flag = builder.flag;
    }

    protected NDArray getRecordImage(NDManager manager, long index) throws IOException {
        NDArray image = this.getImage(index).toNDArray(manager, this.flag);
        Optional<Integer> width = this.getImageWidth();
        Optional<Integer> height = this.getImageHeight();
        if (width.isPresent() && height.isPresent()) {
            image = NDImageUtils.resize((NDArray)image, (int)width.get(), (int)height.get());
        }
        return image;
    }

    protected abstract Image getImage(long var1) throws IOException;

    public int getImageChannels() {
        return this.flag.numChannels();
    }

    public abstract Optional<Integer> getImageWidth();

    public abstract Optional<Integer> getImageHeight();

    public static abstract class BaseBuilder<T extends BaseBuilder<T>>
    extends RandomAccessDataset.BaseBuilder<T> {
        Image.Flag flag = Image.Flag.COLOR;

        protected BaseBuilder() {
        }

        public T optFlag(Image.Flag flag) {
            this.flag = flag;
            return (T)((Object)((BaseBuilder)this.self()));
        }
    }
}

