/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.basicdataset.cv.classification;

import ai.djl.Application;
import ai.djl.basicdataset.BasicDatasets;
import ai.djl.engine.Engine;
import ai.djl.modality.cv.transform.ToTensor;
import ai.djl.ndarray.NDArray;
import ai.djl.ndarray.NDManager;
import ai.djl.repository.Artifact;
import ai.djl.repository.MRL;
import ai.djl.repository.Repository;
import ai.djl.training.dataset.ArrayDataset;
import ai.djl.training.dataset.Dataset;
import ai.djl.training.dataset.RandomAccessDataset;
import ai.djl.translate.Pipeline;
import ai.djl.translate.Transform;
import ai.djl.util.Progress;
import java.io.IOException;
import java.util.Map;

public final class Cifar10
extends ArrayDataset {
    private static final String ARTIFACT_ID = "cifar10";
    private static final String VERSION = "1.0";
    public static final int IMAGE_WIDTH = 32;
    public static final int IMAGE_HEIGHT = 32;
    public static final float[] NORMALIZE_MEAN = new float[]{0.4914f, 0.4822f, 0.4465f};
    public static final float[] NORMALIZE_STD = new float[]{0.2023f, 0.1994f, 0.201f};
    private static final int DATA_AND_LABEL_SIZE = 3073;
    private NDManager manager;
    private Dataset.Usage usage;
    private MRL mrl;
    private boolean prepared;

    Cifar10(Builder builder) {
        super((RandomAccessDataset.BaseBuilder)builder);
        this.manager = builder.manager;
        this.manager.setName(ARTIFACT_ID);
        this.usage = builder.usage;
        this.mrl = builder.getMrl();
    }

    public static Builder builder() {
        return new Builder();
    }

    public void prepare(Progress progress) throws IOException {
        Artifact.Item item;
        if (this.prepared) {
            return;
        }
        Artifact artifact = this.mrl.getDefaultArtifact();
        this.mrl.prepare(artifact, progress);
        Map map = artifact.getFiles();
        switch (this.usage) {
            case TRAIN: {
                item = (Artifact.Item)map.get("data_batch.bin");
                break;
            }
            case TEST: {
                item = (Artifact.Item)map.get("test_batch.bin");
                break;
            }
            default: {
                throw new UnsupportedOperationException("Validation data not available.");
            }
        }
        NDArray dataAndLabels = this.readData(item);
        this.data = new NDArray[]{dataAndLabels.get(":, 1:", new Object[0]).reshape(new long[]{-1L, 3L, 32L, 32L}).transpose(new int[]{0, 2, 3, 1})};
        this.labels = new NDArray[]{dataAndLabels.get(":,0", new Object[0])};
        if (this.data[0].size(0) != this.labels[0].size(0)) {
            throw new IOException("the size of data " + this.data[0].size(0) + " didn't match with the size of labels " + this.labels[0].size(0));
        }
        this.prepared = true;
    }

    /*
     * Exception decompiling
     */
    private NDArray readData(Artifact.Item item) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static final class Builder
    extends RandomAccessDataset.BaseBuilder<Builder> {
        NDManager manager;
        Repository repository = BasicDatasets.REPOSITORY;
        String groupId = "ai.djl.basicdataset";
        String artifactId = "cifar10";
        Dataset.Usage usage = Dataset.Usage.TRAIN;

        Builder() {
            this.pipeline = new Pipeline(new Transform[]{new ToTensor()});
            this.manager = Engine.getInstance().newBaseManager();
        }

        protected Builder self() {
            return this;
        }

        public Builder optManager(NDManager manager) {
            this.manager.close();
            this.manager = manager.newSubManager();
            return this;
        }

        public Builder optRepository(Repository repository) {
            this.repository = repository;
            return this;
        }

        public Builder optGroupId(String groupId) {
            this.groupId = groupId;
            return this;
        }

        public Builder optArtifactId(String artifactId) {
            if (artifactId.contains(":")) {
                String[] tokens = artifactId.split(":");
                this.groupId = tokens[0];
                this.artifactId = tokens[1];
            } else {
                this.artifactId = artifactId;
            }
            return this;
        }

        public Builder optUsage(Dataset.Usage usage) {
            this.usage = usage;
            return this;
        }

        public Cifar10 build() {
            return new Cifar10(this);
        }

        MRL getMrl() {
            return this.repository.dataset(Application.CV.ANY, this.groupId, this.artifactId, Cifar10.VERSION);
        }
    }
}

