/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.basicdataset.cv.classification;

import ai.djl.basicdataset.cv.classification.AbstractImageFolder;
import ai.djl.modality.cv.transform.ToTensor;
import ai.djl.translate.Pipeline;
import ai.djl.translate.Transform;
import ai.djl.util.Progress;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;

public final class ImageFolder
extends AbstractImageFolder {
    private ImageFolder(AbstractImageFolder.ImageFolderBuilder<?> builder) {
        super(builder);
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    protected Path getImagePath(String key) {
        return Paths.get(key, new String[0]);
    }

    public void prepare(Progress progress) throws IOException {
        if (!this.prepared) {
            this.resource.prepare(null, progress);
            this.loadSynset();
            Path root = Paths.get(this.resource.getRepository().getBaseUri());
            if (progress != null) {
                progress.reset("Preparing", 2L);
                progress.start(0L);
                this.listImages(root, this.synset);
                progress.end();
            } else {
                this.listImages(root, this.synset);
            }
            this.prepared = true;
        }
    }

    private void loadSynset() {
        File root = new File(this.resource.getRepository().getBaseUri());
        Object[] dir = root.listFiles(f -> f.isDirectory() && !f.getName().startsWith("."));
        if (dir == null || dir.length == 0) {
            throw new IllegalArgumentException(root + " not found or didn't have any file in it");
        }
        Arrays.sort(dir);
        for (Object file : dir) {
            this.synset.add(((File)file).getName());
        }
    }

    public static final class Builder
    extends AbstractImageFolder.ImageFolderBuilder<Builder> {
        Builder() {
        }

        protected Builder self() {
            return this;
        }

        public ImageFolder build() {
            if (this.pipeline == null) {
                this.pipeline = new Pipeline(new Transform[]{new ToTensor()});
            }
            return new ImageFolder(this);
        }
    }
}

