/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.security.AccessController;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ClassLoaderUtils {
    private static final Logger logger = LoggerFactory.getLogger(ClassLoaderUtils.class);

    private ClassLoaderUtils() {
    }

    public static <T> T findImplementation(Path path, Class<T> type, String className) {
        try {
            Path classesDir = path.resolve("classes");
            List<Path> jarFiles = Files.isDirectory(path, new LinkOption[0]) ? Files.list(path).filter(p -> p.toString().endsWith(".jar")).collect(Collectors.toList()) : Collections.emptyList();
            URL[] urls = new URL[jarFiles.size() + 1];
            urls[0] = classesDir.toUri().toURL();
            int index = 1;
            for (Path p2 : jarFiles) {
                urls[index++] = p2.toUri().toURL();
            }
            ClassLoader contextCl = ClassLoaderUtils.getContextClassLoader();
            ClassLoader cl = AccessController.doPrivileged(() -> new URLClassLoader(urls, contextCl));
            if (className != null && !className.isEmpty()) {
                return ClassLoaderUtils.initClass(cl, type, className);
            }
            T implemented = ClassLoaderUtils.scanDirectory(cl, type, classesDir);
            if (implemented != null) {
                return implemented;
            }
            for (Path p3 : jarFiles) {
                implemented = ClassLoaderUtils.scanJarFile(cl, type, p3);
                if (implemented == null) continue;
                return implemented;
            }
        }
        catch (IOException e) {
            logger.debug("Failed to find Translator", (Throwable)e);
        }
        return null;
    }

    private static <T> T scanDirectory(ClassLoader cl, Class<T> type, Path dir) throws IOException {
        if (!Files.isDirectory(dir, new LinkOption[0])) {
            logger.trace("Directory not exists: {}", (Object)dir);
            return null;
        }
        Collection files = Files.walk(dir, new FileVisitOption[0]).filter(p -> Files.isRegularFile(p, new LinkOption[0]) && p.toString().endsWith(".class")).collect(Collectors.toList());
        for (Path file : files) {
            Path p2 = dir.relativize(file);
            String className = p2.toString();
            className = className.substring(0, className.lastIndexOf(46));
            T implemented = ClassLoaderUtils.initClass(cl, type, className = className.replace(File.separatorChar, '.'));
            if (implemented == null) continue;
            return implemented;
        }
        return null;
    }

    private static <T> T scanJarFile(ClassLoader cl, Class<T> type, Path path) throws IOException {
        try (JarFile jarFile = new JarFile(path.toFile());){
            Enumeration<JarEntry> en = jarFile.entries();
            while (en.hasMoreElements()) {
                JarEntry entry = en.nextElement();
                String fileName = entry.getName();
                if (!fileName.endsWith(".class")) continue;
                fileName = fileName.substring(0, fileName.lastIndexOf(46));
                T implemented = ClassLoaderUtils.initClass(cl, type, fileName = fileName.replace('/', '.'));
                if (implemented == null) continue;
                T t = implemented;
                return t;
            }
        }
        return null;
    }

    public static <T> T initClass(ClassLoader cl, Class<T> type, String className) {
        try {
            Class<?> clazz = Class.forName(className, true, cl);
            Class<T> sub = clazz.asSubclass(type);
            Constructor<T> constructor = sub.getConstructor(new Class[0]);
            return constructor.newInstance(new Object[0]);
        }
        catch (Throwable e) {
            logger.trace("Not able to load Object", e);
            return null;
        }
    }

    public static ClassLoader getContextClassLoader() {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == null) {
            return ClassLoaderUtils.class.getClassLoader();
        }
        return cl;
    }

    public static Enumeration<URL> getResources(String name) throws IOException {
        return ClassLoaderUtils.getContextClassLoader().getResources(name);
    }

    public static URL getResource(String name) throws IOException {
        Enumeration<URL> en = ClassLoaderUtils.getResources(name);
        if (en.hasMoreElements()) {
            return en.nextElement();
        }
        return null;
    }

    public static InputStream getResourceAsStream(String name) throws IOException {
        URL url = ClassLoaderUtils.getResource(name);
        if (url == null) {
            throw new IOException("Resource not found in classpath: " + name);
        }
        return url.openStream();
    }

    public static void nativeLoad(String nativeHelper, String path) {
        try {
            Class<?> clazz = Class.forName(nativeHelper, true, ClassLoaderUtils.getContextClassLoader());
            Method method = clazz.getDeclaredMethod("load", String.class);
            method.invoke(null, path);
        }
        catch (ReflectiveOperationException e) {
            throw new IllegalArgumentException("Invalid native_helper: " + nativeHelper, e);
        }
    }
}

