/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.modality.nlp.translator;

import ai.djl.modality.Input;
import ai.djl.modality.Output;
import ai.djl.ndarray.BytesSupplier;
import ai.djl.ndarray.NDList;
import ai.djl.translate.Batchifier;
import ai.djl.translate.NoBatchifyTranslator;
import ai.djl.translate.TranslateException;
import ai.djl.translate.Translator;
import ai.djl.translate.TranslatorContext;
import ai.djl.util.JsonUtils;

public class TextEmbeddingServingTranslator
implements NoBatchifyTranslator<Input, Output> {
    private Translator<String, float[]> translator;
    private Translator<String[], float[][]> batchTranslator;

    public TextEmbeddingServingTranslator(Translator<String, float[]> translator) {
        this.translator = translator;
        this.batchTranslator = translator.toBatchTranslator();
    }

    @Override
    public void prepare(TranslatorContext ctx) throws Exception {
        this.translator.prepare(ctx);
        this.batchTranslator.prepare(ctx);
    }

    @Override
    public NDList processInput(TranslatorContext ctx, Input input) throws Exception {
        if (input.getContent().isEmpty()) {
            throw new TranslateException("Input data is empty.");
        }
        String contentType = input.getProperty("Content-Type", null);
        String text = input.getData().getAsString();
        if ("application/json".equals(contentType)) {
            ctx.setAttachment("batch", Boolean.TRUE);
            String[] inputs = (String[])JsonUtils.GSON.fromJson(text, String[].class);
            return this.batchTranslator.processInput(ctx, inputs);
        }
        NDList ret = this.translator.processInput(ctx, text);
        Batchifier batchifier = this.translator.getBatchifier();
        if (batchifier != null) {
            NDList[] batch = new NDList[]{ret};
            return batchifier.batchify(batch);
        }
        return ret;
    }

    @Override
    public Output processOutput(TranslatorContext ctx, NDList list) throws Exception {
        Output output = new Output();
        output.addProperty("Content-Type", "application/json");
        if (ctx.getAttachment("batch") != null) {
            output.add(BytesSupplier.wrapAsJson(this.batchTranslator.processOutput(ctx, list)));
        } else {
            Batchifier batchifier = this.translator.getBatchifier();
            if (batchifier != null) {
                list = batchifier.unbatchify(list)[0];
            }
            output.add(BytesSupplier.wrapAsJson(this.translator.processOutput(ctx, list)));
        }
        return output;
    }
}

