/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.inference.streaming;

import ai.djl.ndarray.BytesSupplier;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;

public class PublisherBytesSupplier
implements BytesSupplier {
    private final List<byte[]> allData = new ArrayList<byte[]>();
    private final AtomicBoolean completed = new AtomicBoolean();
    private Consumer<byte[]> subscriber;
    private final AtomicInteger dataPushed = new AtomicInteger();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void appendContent(byte[] data, boolean lastChunk) {
        List<byte[]> list = this.allData;
        synchronized (list) {
            this.allData.add(data);
        }
        if (lastChunk) {
            this.completed.set(true);
        }
        this.pushData();
    }

    public void subscribe(Consumer<byte[]> subscriber) {
        if (this.subscriber != null) {
            throw new IllegalStateException("The PublisherBytesSupplier only allows a single Subscriber");
        }
        this.subscriber = subscriber;
        this.pushData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pushData() {
        int sent;
        int dataAvailable;
        if (this.subscriber == null) {
            return;
        }
        List<byte[]> list = this.allData;
        synchronized (list) {
            dataAvailable = this.allData.size();
        }
        if (sent < dataAvailable) {
            PublisherBytesSupplier publisherBytesSupplier = this;
            synchronized (publisherBytesSupplier) {
                for (sent = this.dataPushed.getAndSet(dataAvailable); sent < dataAvailable; ++sent) {
                    this.subscriber.accept(this.allData.get(sent));
                }
                if (this.completed.get()) {
                    this.subscriber.accept(null);
                }
            }
        }
    }

    public void waitToRead() {
        while (!this.completed.get()) {
        }
    }

    @Override
    public byte[] getAsBytes() {
        Object object;
        if (!this.completed.get()) {
            throw new IllegalStateException("PublisherByteSupplier must be completely filled before reading.");
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            for (byte[] data : this.allData) {
                bos.write(data);
            }
            object = bos.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    bos.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new AssertionError("Failed to read BytesSupplier", e);
            }
        }
        bos.close();
        return object;
    }

    @Override
    public ByteBuffer toByteBuffer() {
        return ByteBuffer.wrap(this.getAsBytes());
    }
}

