/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.repository.zoo;

import ai.djl.Application;
import ai.djl.Device;
import ai.djl.MalformedModelException;
import ai.djl.Model;
import ai.djl.engine.Engine;
import ai.djl.nn.Block;
import ai.djl.nn.BlockFactory;
import ai.djl.repository.Artifact;
import ai.djl.repository.MRL;
import ai.djl.repository.zoo.Criteria;
import ai.djl.repository.zoo.ModelLoader;
import ai.djl.repository.zoo.ModelNotFoundException;
import ai.djl.repository.zoo.ModelZoo;
import ai.djl.repository.zoo.ZooModel;
import ai.djl.translate.DefaultTranslatorFactory;
import ai.djl.translate.TranslateException;
import ai.djl.translate.Translator;
import ai.djl.translate.TranslatorFactory;
import ai.djl.util.ClassLoaderUtils;
import ai.djl.util.Pair;
import ai.djl.util.Progress;
import ai.djl.util.Utils;
import java.io.BufferedReader;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;

public class BaseModelLoader
implements ModelLoader {
    protected MRL mrl;
    protected TranslatorFactory defaultFactory;

    public BaseModelLoader(MRL mrl) {
        this.mrl = mrl;
        this.defaultFactory = new DefaultTranslatorFactory();
    }

    @Override
    public String getArtifactId() {
        return this.mrl.getArtifactId();
    }

    @Override
    public Application getApplication() {
        return this.mrl.getApplication();
    }

    @Override
    public <I, O> ZooModel<I, O> loadModel(Criteria<I, O> criteria) throws IOException, ModelNotFoundException, MalformedModelException {
        Artifact artifact = this.mrl.match(criteria.getFilters());
        if (artifact == null) {
            throw new ModelNotFoundException("No matching filter found");
        }
        Progress progress = criteria.getProgress();
        Map<String, Object> arguments = artifact.getArguments(criteria.getArguments());
        Map<String, String> options = artifact.getOptions(criteria.getOptions());
        try {
            ModelZoo modelZoo;
            String engine;
            Path modelPath;
            Path modelDir;
            TranslatorFactory factory = this.getTranslatorFactory(criteria, arguments);
            Class<I> input = criteria.getInputClass();
            Class<O> output = criteria.getOutputClass();
            if (!(factory != null && factory.isSupported(input, output) || (factory = this.defaultFactory).isSupported(input, output))) {
                throw new ModelNotFoundException(this.getFactoryLookupErrorMessage(factory));
            }
            this.mrl.prepare(artifact, progress);
            if (progress != null) {
                progress.reset("Loading", 2L);
                progress.update(1L);
            }
            Path path = modelDir = Files.isRegularFile(modelPath = this.mrl.getRepository().getResourceDirectory(artifact), new LinkOption[0]) ? modelPath.getParent() : modelPath;
            if (modelDir == null) {
                throw new AssertionError((Object)"Directory should not be null.");
            }
            modelDir = Utils.getNestedModelDir(modelDir);
            this.loadServingProperties(modelDir, arguments, options);
            Application application = criteria.getApplication();
            if (application != Application.UNDEFINED) {
                arguments.put("application", application.getPath());
            }
            if ((engine = criteria.getEngine()) == null) {
                engine = (String)arguments.get("engine");
            }
            if (engine == null && (modelZoo = ModelZoo.getModelZoo(this.mrl.getGroupId())) != null) {
                String defaultEngine = Engine.getDefaultEngineName();
                for (String supportedEngine : modelZoo.getSupportedEngines()) {
                    if (supportedEngine.equals(defaultEngine)) {
                        engine = supportedEngine;
                        break;
                    }
                    if (!Engine.hasEngine(supportedEngine)) continue;
                    engine = supportedEngine;
                }
                if (engine == null) {
                    throw new ModelNotFoundException("No supported engine available for model zoo: " + modelZoo.getGroupId());
                }
            }
            if (engine != null && !Engine.hasEngine(engine)) {
                throw new ModelNotFoundException(engine + " is not supported");
            }
            String modelName = criteria.getModelName();
            if (modelName == null && (modelName = options.get("modelName")) == null) {
                modelName = artifact.getName();
            }
            Model model = this.createModel(modelDir, modelName, criteria.getDevice(), criteria.getBlock(), arguments, engine);
            model.load(modelPath, null, options);
            Translator<I, O> translator = factory.newInstance(input, output, model, arguments);
            ZooModel<I, O> zooModel = new ZooModel<I, O>(model, translator);
            return zooModel;
        }
        catch (TranslateException e) {
            throw new ModelNotFoundException("No matching translator found", e);
        }
        finally {
            if (progress != null) {
                progress.end();
            }
        }
    }

    @Override
    public List<Artifact> listModels() throws IOException {
        List<Artifact> list = this.mrl.listArtifacts();
        String version = this.mrl.getVersion();
        return list.stream().filter(a -> version == null || version.equals(a.getVersion())).collect(Collectors.toList());
    }

    protected Model createModel(Path modelPath, String name, Device device, Block block, Map<String, Object> arguments, String engine) throws IOException {
        String className;
        BlockFactory factory;
        Model model = Model.newInstance(name, device, engine);
        if (block == null && (factory = ClassLoaderUtils.findImplementation(modelPath, BlockFactory.class, className = (String)arguments.get("blockFactory"))) != null) {
            block = factory.newBlock(model, modelPath, arguments);
        }
        if (block != null) {
            model.setBlock(block);
        }
        for (Map.Entry<String, Object> entry : arguments.entrySet()) {
            model.setProperty(entry.getKey(), entry.getValue().toString());
        }
        return model;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(200);
        sb.append(this.mrl.getGroupId()).append(':').append(this.mrl.getArtifactId()).append(' ').append(this.getApplication()).append(" [\n");
        try {
            for (Artifact artifact : this.listModels()) {
                sb.append('\t').append(artifact).append('\n');
            }
        }
        catch (IOException e) {
            sb.append("\tFailed load metadata.");
        }
        sb.append(']');
        return sb.toString();
    }

    protected TranslatorFactory getTranslatorFactory(Criteria<?, ?> criteria, Map<String, Object> arguments) {
        TranslatorFactory factory = criteria.getTranslatorFactory();
        if (factory != null) {
            return factory;
        }
        String factoryClass = (String)arguments.get("translatorFactory");
        if (factoryClass != null) {
            ClassLoader cl = ClassLoaderUtils.getContextClassLoader();
            factory = ClassLoaderUtils.initClass(cl, TranslatorFactory.class, factoryClass);
        }
        return factory;
    }

    private String getFactoryLookupErrorMessage(TranslatorFactory factory) {
        StringBuilder sb = new StringBuilder(200);
        sb.append("No matching default translator found. The valid input and output classes are: \n");
        for (Pair<Type, Type> io : factory.getSupportedTypes()) {
            sb.append("\t(").append(io.getKey().getTypeName()).append(", ").append(io.getValue().getTypeName()).append(")\n");
        }
        return sb.toString();
    }

    private void loadServingProperties(Path modelDir, Map<String, Object> arguments, Map<String, String> options) throws IOException {
        Path manifestFile = modelDir.resolve("serving.properties");
        if (Files.isRegularFile(manifestFile, new LinkOption[0])) {
            Properties prop = new Properties();
            try (BufferedReader reader = Files.newBufferedReader(manifestFile);){
                prop.load(reader);
            }
            for (String key : prop.stringPropertyNames()) {
                if (key.startsWith("option.")) {
                    options.putIfAbsent(key.substring(7), prop.getProperty(key));
                    continue;
                }
                arguments.putIfAbsent(key, prop.getProperty(key));
            }
        }
    }
}

