/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.translate;

import ai.djl.Model;
import ai.djl.translate.Translator;
import ai.djl.translate.TranslatorFactory;
import ai.djl.translate.TranslatorOptions;
import ai.djl.util.Pair;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;

public abstract class ExpansionTranslatorFactory<IbaseT, ObaseT>
implements TranslatorFactory {
    @Override
    public Set<Pair<Type, Type>> getSupportedTypes() {
        return this.getExpansions().keySet();
    }

    @Override
    public <I, O> Translator<I, O> newInstance(Class<I> input, Class<O> output, Model model, Map<String, ?> arguments) {
        Translator<IbaseT, ObaseT> baseTranslator = this.buildBaseTranslator(model, arguments);
        return this.newInstance(input, output, baseTranslator);
    }

    <I, O> Translator<I, O> newInstance(Class<I> input, Class<O> output, Translator<IbaseT, ObaseT> translator) {
        Function<Translator<IbaseT, ObaseT>, Translator<?, ?>> expansion = this.getExpansions().get(new Pair<Class<I>, Class<O>>(input, output));
        if (expansion == null) {
            throw new IllegalArgumentException("Unsupported expansion input/output types.");
        }
        return expansion.apply(translator);
    }

    public ExpandedTranslatorOptions withTranslator(Translator<IbaseT, ObaseT> translator) {
        return new ExpandedTranslatorOptions(translator);
    }

    protected abstract Translator<IbaseT, ObaseT> buildBaseTranslator(Model var1, Map<String, ?> var2);

    protected abstract Map<Pair<Type, Type>, Function<Translator<IbaseT, ObaseT>, Translator<?, ?>>> getExpansions();

    final class ExpandedTranslatorOptions
    implements TranslatorOptions {
        private Translator<IbaseT, ObaseT> translator;

        private ExpandedTranslatorOptions(Translator<IbaseT, ObaseT> translator) {
            this.translator = translator;
        }

        @Override
        public Set<Pair<Type, Type>> getOptions() {
            return ExpansionTranslatorFactory.this.getSupportedTypes();
        }

        @Override
        public <I, O> Translator<I, O> option(Class<I> input, Class<O> output) {
            return ExpansionTranslatorFactory.this.newInstance(input, output, this.translator);
        }
    }
}

