/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.training.dataset;

import ai.djl.Device;
import ai.djl.ndarray.NDList;
import ai.djl.ndarray.NDManager;
import ai.djl.training.dataset.Batch;
import ai.djl.training.dataset.RandomAccessDataset;
import ai.djl.training.dataset.Record;
import ai.djl.training.dataset.Sampler;
import ai.djl.translate.Batchifier;
import ai.djl.translate.Pipeline;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataIterable
implements Iterable<Batch>,
Iterator<Batch> {
    private static final Logger logger = LoggerFactory.getLogger(DataIterable.class);
    private RandomAccessDataset dataset;
    private NDManager manager;
    private Batchifier batchifier;
    private Pipeline pipeline;
    private Pipeline targetPipeline;
    private ExecutorService executor;
    private long maxIteration;
    private Device device;
    private Iterator<List<Long>> sample;
    private Queue<Future<Batch>> queue;
    private long count;

    public DataIterable(RandomAccessDataset dataset, NDManager manager, Sampler sampler, Batchifier batchifier, Pipeline pipeline, Pipeline targetPipeline, ExecutorService executor, int preFetchNumber, long maxIteration, Device device) {
        this.dataset = dataset;
        this.manager = manager.newSubManager();
        this.batchifier = batchifier;
        this.pipeline = pipeline;
        this.targetPipeline = targetPipeline;
        this.executor = executor;
        this.maxIteration = maxIteration;
        this.device = device;
        this.sample = sampler.sample(dataset);
        if (executor != null) {
            this.queue = new LinkedList<Future<Batch>>();
            for (int i = 0; i < preFetchNumber; ++i) {
                this.preFetch();
            }
        }
    }

    @Override
    public Iterator<Batch> iterator() {
        return this;
    }

    @Override
    public boolean hasNext() {
        if (++this.count > this.maxIteration) {
            return false;
        }
        if (this.executor != null) {
            if (this.queue.isEmpty()) {
                this.manager.close();
                return false;
            }
            return true;
        }
        if (!this.sample.hasNext()) {
            this.manager.close();
            return false;
        }
        return true;
    }

    @Override
    public Batch next() {
        if (this.executor == null) {
            List<Long> indices = this.sample.next();
            try {
                return this.fetch(indices);
            }
            catch (IOException e) {
                logger.error(e.getMessage());
                throw new IllegalStateException("Data loading failed", e);
            }
        }
        this.preFetch();
        Future<Batch> future = this.queue.poll();
        try {
            return future.get();
        }
        catch (InterruptedException | ExecutionException e) {
            logger.error(e.getMessage());
            throw new IllegalStateException("Data loading failed", e);
        }
    }

    private Batch fetch(List<Long> indices) throws IOException {
        NDManager subManager = this.manager.newSubManager();
        NDList[] data = new NDList[indices.size()];
        NDList[] labels = new NDList[indices.size()];
        for (int i = 0; i < indices.size(); ++i) {
            Record record = this.dataset.get(subManager, indices.get(i));
            data[i] = record.getData();
            if (this.pipeline != null) {
                data[i] = this.pipeline.transform(data[i]);
            }
            labels[i] = record.getLabels();
        }
        NDList batchData = this.batchifier.batchify(data);
        NDList batchLabels = this.batchifier.batchify(labels);
        Arrays.stream(data).forEach(NDList::close);
        Arrays.stream(labels).forEach(NDList::close);
        if (this.targetPipeline != null) {
            batchLabels = this.targetPipeline.transform(batchLabels);
        }
        if (this.device != null) {
            batchData = batchData.asInDevice(this.device, false);
            batchLabels = batchLabels.asInDevice(this.device, false);
        }
        return new Batch(subManager, batchData, batchLabels, this.batchifier);
    }

    private void preFetch() {
        if (!this.sample.hasNext()) {
            return;
        }
        List<Long> indices = this.sample.next();
        PreFetchCallable task = new PreFetchCallable(indices);
        Future<Batch> result = this.executor.submit(task);
        this.queue.offer(result);
    }

    class PreFetchCallable
    implements Callable<Batch> {
        private List<Long> indices;

        public PreFetchCallable(List<Long> indices) {
            this.indices = indices;
        }

        @Override
        public Batch call() throws IOException {
            return DataIterable.this.fetch(this.indices);
        }
    }
}

