/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.modality.cv;

import ai.djl.modality.cv.BoundingBox;
import ai.djl.modality.cv.DetectedObjects;
import ai.djl.modality.cv.Joints;
import ai.djl.modality.cv.Mask;
import ai.djl.modality.cv.Point;
import ai.djl.modality.cv.util.BufferedImageUtils;
import ai.djl.util.RandomUtils;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.util.List;

public final class ImageVisualization {
    private ImageVisualization() {
    }

    public static void drawBoundingBoxes(BufferedImage image, DetectedObjects detections) {
        Graphics2D g = (Graphics2D)image.getGraphics();
        int stroke = 2;
        g.setStroke(new BasicStroke(stroke));
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int imageWidth = image.getWidth();
        int imageHeight = image.getHeight();
        List list = detections.items();
        for (DetectedObjects.DetectedObject result : list) {
            String className = result.getClassName();
            BoundingBox box = result.getBoundingBox();
            g.setPaint(BufferedImageUtils.randomColor().darker());
            box.draw(g, imageWidth, imageHeight);
            Point p = box.getPoint();
            int x = (int)(p.getX() * (double)imageWidth);
            int y = (int)(p.getY() * (double)imageHeight);
            ImageVisualization.drawText(g, className, x, y, stroke, 4);
            if (!(box instanceof Mask)) continue;
            Mask mask = (Mask)box;
            ImageVisualization.drawMask(image, mask);
        }
        g.dispose();
    }

    private static void drawMask(BufferedImage image, Mask mask) {
        float r = RandomUtils.nextFloat();
        float g = RandomUtils.nextFloat();
        float b = RandomUtils.nextFloat();
        int imageWidth = image.getWidth();
        int imageHeight = image.getHeight();
        int x = (int)(mask.getX() * (double)imageWidth);
        int y = (int)(mask.getY() * (double)imageHeight);
        float[][] probDist = mask.getProbDist();
        if (x < 0) {
            x = 0;
        }
        if (y < 0) {
            y = 0;
        }
        BufferedImage maskImage = new BufferedImage(probDist.length, probDist[0].length, 2);
        for (int xCor = 0; xCor < probDist.length; ++xCor) {
            for (int yCor = 0; yCor < probDist[xCor].length; ++yCor) {
                float opacity = probDist[xCor][yCor];
                if ((double)opacity < 0.1) {
                    opacity = 0.0f;
                }
                if ((double)opacity > 0.8) {
                    opacity = 0.8f;
                }
                maskImage.setRGB(xCor, yCor, new Color(r, g, b, opacity).darker().getRGB());
            }
        }
        Graphics2D gR = (Graphics2D)image.getGraphics();
        gR.drawImage((Image)maskImage, x, y, null);
        gR.dispose();
    }

    private static void drawText(Graphics2D g, String text, int x, int y, int stroke, int padding) {
        FontMetrics metrics = g.getFontMetrics();
        int width = metrics.stringWidth(text) + padding * 2 - stroke / 2;
        int height = metrics.getHeight() + metrics.getDescent();
        int ascent = metrics.getAscent();
        Rectangle background = new Rectangle(x += stroke / 2, y += stroke / 2, width, height);
        g.fill(background);
        g.setPaint(Color.WHITE);
        g.drawString(text, x + padding, y + ascent);
    }

    public static void drawJoints(BufferedImage image, Joints joints) {
        Graphics2D g = (Graphics2D)image.getGraphics();
        int stroke = 2;
        g.setStroke(new BasicStroke(stroke));
        int imageWidth = image.getWidth();
        int imageHeight = image.getHeight();
        for (Joints.Joint joint : joints.getJoints()) {
            g.setPaint(BufferedImageUtils.randomColor().darker());
            int x = (int)(joint.getX() * (double)imageWidth);
            int y = (int)(joint.getY() * (double)imageHeight);
            g.fillOval(x, y, 10, 10);
        }
        g.dispose();
    }
}

