/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.modality.cv;

import ai.djl.Model;
import ai.djl.modality.Classifications;
import ai.djl.modality.cv.ImageTranslator;
import ai.djl.ndarray.NDArray;
import ai.djl.ndarray.NDList;
import ai.djl.translate.TranslatorContext;
import ai.djl.util.Utils;
import java.io.IOException;
import java.util.List;

public class ImageClassificationTranslator
extends ImageTranslator<Classifications> {
    private String synsetArtifactName;

    public ImageClassificationTranslator(Builder builder) {
        super(builder);
        this.synsetArtifactName = builder.synsetArtifactName;
    }

    @Override
    public Classifications processOutput(TranslatorContext ctx, NDList list) throws IOException {
        Model model = ctx.getModel();
        NDArray probabilitiesNd = list.singletonOrThrow().softmax(0);
        List synset = model.getArtifact(this.synsetArtifactName, Utils::readLines);
        return new Classifications((List<String>)synset, probabilitiesNd);
    }

    public static class Builder
    extends ImageTranslator.BaseBuilder<Builder> {
        private String synsetArtifactName;

        public Builder setSynsetArtifactName(String synsetArtifactName) {
            this.synsetArtifactName = synsetArtifactName;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        public ImageClassificationTranslator build() {
            if (this.synsetArtifactName == null) {
                throw new IllegalArgumentException("You must specify a synset artifact name");
            }
            return new ImageClassificationTranslator(this);
        }
    }
}

