/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.engine;

import ai.djl.Device;
import ai.djl.Model;
import ai.djl.engine.EngineException;
import ai.djl.engine.EngineProvider;
import ai.djl.ndarray.NDManager;
import java.lang.management.MemoryUsage;
import java.util.ArrayList;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Engine {
    private static final Logger logger = LoggerFactory.getLogger(Engine.class);
    private static final Map<String, Engine> ALL_ENGINES = new ConcurrentHashMap<String, Engine>();
    private static final Engine ENGINE = Engine.initEngine();

    private static synchronized Engine initEngine() {
        ServiceLoader<EngineProvider> loaders = ServiceLoader.load(EngineProvider.class);
        ArrayList<EngineProvider> list = new ArrayList<EngineProvider>();
        for (EngineProvider provider : loaders) {
            list.add(provider);
            Engine engine = provider.getEngine();
            ALL_ENGINES.put(engine.getEngineName(), engine);
        }
        if (list.isEmpty()) {
            return null;
        }
        if (list.size() > 1) {
            logger.warn("More than one deep learning engines found.");
        }
        Engine engine = ((EngineProvider)list.get(0)).getEngine();
        logger.debug("Loading ML engine from: {}", engine.getClass());
        return engine;
    }

    public abstract String getEngineName();

    public static Engine getInstance() {
        if (ENGINE == null) {
            throw new EngineException("No deep learning engine found in class path.");
        }
        return ENGINE;
    }

    public static Engine getEngine(String engineName) {
        return ALL_ENGINES.get(engineName);
    }

    public abstract int getGpuCount();

    public abstract MemoryUsage getGpuMemory(Device var1);

    public abstract Device defaultDevice();

    public abstract String getVersion();

    public abstract Model newModel(Device var1);

    public abstract NDManager newBaseManager();

    public abstract NDManager newBaseManager(Device var1);
}

