/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.util;

import ai.djl.util.Pair;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class PairList<K, V>
implements Iterable<Pair<K, V>> {
    private List<K> keys;
    private List<V> values;

    public PairList() {
        this.keys = new ArrayList<K>();
        this.values = new ArrayList<V>();
    }

    public PairList(int initialCapacity) {
        this.keys = new ArrayList<K>(initialCapacity);
        this.values = new ArrayList<V>(initialCapacity);
    }

    public PairList(List<K> keys, List<V> values) {
        if (keys.size() != values.size()) {
            throw new IllegalArgumentException("key value size mismatch.");
        }
        this.keys = keys;
        this.values = values;
    }

    public PairList(List<Pair<K, V>> list) {
        this(list.size());
        for (Pair<K, V> pair : list) {
            this.keys.add(pair.getKey());
            this.values.add(pair.getValue());
        }
    }

    public PairList(Map<K, V> map) {
        this.keys = new ArrayList<K>(map.size());
        this.values = new ArrayList<V>(map.size());
        for (Map.Entry<K, V> entry : map.entrySet()) {
            this.keys.add(entry.getKey());
            this.values.add(entry.getValue());
        }
    }

    public void add(int index, K key, V value) {
        this.keys.add(index, key);
        this.values.add(index, value);
    }

    public void add(K key, V value) {
        this.keys.add(key);
        this.values.add(value);
    }

    public void add(Pair<K, V> pair) {
        this.keys.add(pair.getKey());
        this.values.add(pair.getValue());
    }

    public void addAll(PairList<K, V> other) {
        if (other != null) {
            this.keys.addAll(other.keys());
            this.values.addAll(other.values());
        }
    }

    public int size() {
        return this.keys.size();
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public Pair<K, V> get(int index) {
        return new Pair<K, V>(this.keys.get(index), this.values.get(index));
    }

    public V get(K key) {
        int index = this.keys.indexOf(key);
        if (index == -1) {
            return null;
        }
        return this.values.get(index);
    }

    public K keyAt(int index) {
        return this.keys.get(index);
    }

    public V valueAt(int index) {
        return this.values.get(index);
    }

    public List<K> keys() {
        return this.keys;
    }

    public List<V> values() {
        return this.values;
    }

    public K[] keyArray(K[] target) {
        return this.keys.toArray(target);
    }

    public V[] valueArray(V[] target) {
        return this.values.toArray(target);
    }

    public V remove(K key) {
        int index = this.keys.indexOf(key);
        if (index == -1) {
            return null;
        }
        return this.remove(index);
    }

    public V remove(int index) {
        this.keys.remove(index);
        return this.values.remove(index);
    }

    public PairList<K, V> subList(int fromIndex) {
        return this.subList(fromIndex, this.size());
    }

    public PairList<K, V> subList(int fromIndex, int toIndex) {
        List<K> subKeys = this.keys.subList(fromIndex, toIndex);
        List<V> subValues = this.values.subList(fromIndex, toIndex);
        return new PairList<K, V>(subKeys, subValues);
    }

    public Stream<Pair<K, V>> stream() {
        return StreamSupport.stream(this.spliterator(), false);
    }

    public boolean contains(K key) {
        return this.keys.contains(key);
    }

    public PairList<K, V> unique() {
        return new PairList<K, V>(this.toMap(false));
    }

    @Override
    public Iterator<Pair<K, V>> iterator() {
        return new Itr();
    }

    public Map<K, V> toMap() {
        return this.toMap(true);
    }

    public Map<K, V> toMap(boolean checkDuplicate) {
        int size = this.keys.size();
        ConcurrentHashMap<K, V> map = new ConcurrentHashMap<K, V>(size * 3 / 2);
        for (int i = 0; i < size; ++i) {
            if (map.put(this.keys.get(i), this.values.get(i)) == null || !checkDuplicate) continue;
            throw new IllegalStateException("Duplicate keys: " + this.keys.get(i));
        }
        return map;
    }

    private class Itr
    implements Iterator<Pair<K, V>> {
        private int cursor;
        private int size;

        Itr() {
            this.size = PairList.this.size();
        }

        @Override
        public boolean hasNext() {
            return this.cursor < this.size;
        }

        @Override
        public Pair<K, V> next() {
            if (this.cursor >= this.size) {
                throw new NoSuchElementException();
            }
            return PairList.this.get(this.cursor++);
        }
    }
}

