/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.repository;

import ai.djl.repository.FilenameUtils;
import ai.djl.repository.JarRepository;
import ai.djl.repository.LocalRepository;
import ai.djl.repository.RemoteRepository;
import ai.djl.repository.Repository;
import ai.djl.repository.RepositoryFactory;
import ai.djl.repository.SimpleRepository;
import ai.djl.repository.SimpleUrlRepository;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RepositoryFactoryImpl
implements RepositoryFactory {
    private static final Logger logger = LoggerFactory.getLogger(RepositoryFactoryImpl.class);
    private static final Pattern NAME_PATTERN = Pattern.compile("model_name=([^&]*)");
    private static final Pattern ARTIFACT_PATTERN = Pattern.compile("artifact_id=([^&]*)");
    private static final RepositoryFactory FACTORY = new RepositoryFactoryImpl();
    private static final Map<String, RepositoryFactory> REGISTRY = RepositoryFactoryImpl.init();

    RepositoryFactoryImpl() {
    }

    static RepositoryFactory getFactory() {
        return FACTORY;
    }

    @Override
    public Repository newInstance(String name, String url) {
        String uriPath;
        RepositoryFactory factory;
        URI uri = URI.create(url);
        String scheme = uri.getScheme();
        if (scheme == null) {
            scheme = "file";
        }
        if ((factory = REGISTRY.get(scheme)) != null) {
            return factory.newInstance(name, url);
        }
        if ("jar".equals(scheme)) {
            URL u;
            String p = uri.getPath();
            if (p.startsWith("/")) {
                p = p.substring(1);
            }
            if ((u = Thread.currentThread().getContextClassLoader().getResource(p)) == null) {
                throw new IllegalArgumentException("Resource not found: " + url);
            }
            try {
                uri = u.toURI();
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException("Resource not found: " + url, e);
            }
        }
        if (!"file".equals(scheme)) {
            try {
                uri.toURL();
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException("Malformed URL: " + url, e);
            }
        }
        if ((uriPath = uri.getPath()).startsWith("/") && System.getProperty("os.name").startsWith("Win")) {
            uriPath = uriPath.substring(1);
        }
        Path path = Paths.get(uriPath, new String[0]);
        String fileName = path.toFile().getName();
        String[] names = RepositoryFactoryImpl.parseQueryString(uri, fileName);
        if ("file".equalsIgnoreCase(scheme)) {
            if (Files.exists(path, new LinkOption[0]) && Files.isDirectory(path, new LinkOption[0])) {
                try {
                    if (Files.walk(path, new FileVisitOption[0]).anyMatch(f -> f.endsWith("metadata.json") && Files.isRegularFile(f, new LinkOption[0]) && !f.getParent().equals(path))) {
                        logger.debug("Found local repository: {}", (Object)path);
                        return new LocalRepository(name, path);
                    }
                }
                catch (IOException e) {
                    logger.warn("Failed locate metadata.json file, defaulting to simple", (Throwable)e);
                }
            }
            return new SimpleRepository(name, path, names[0], names[1]);
        }
        if ("jar".equals(scheme)) {
            if (!FilenameUtils.isArchiveFile(fileName)) {
                throw new IllegalArgumentException("Only archive file is supported for res URL.");
            }
            return new JarRepository(name, uri, names[0], names[1]);
        }
        if (FilenameUtils.isArchiveFile(fileName)) {
            return new SimpleUrlRepository(name, uri, names[0], names[1]);
        }
        return new RemoteRepository(name, uri);
    }

    @Override
    public Set<String> getSupportedScheme() {
        return Collections.emptySet();
    }

    static void registerRepositoryFactory(RepositoryFactory factory) {
        for (String scheme : factory.getSupportedScheme()) {
            REGISTRY.put(scheme, factory);
        }
    }

    private static Map<String, RepositoryFactory> init() {
        ConcurrentHashMap<String, RepositoryFactory> registry = new ConcurrentHashMap<String, RepositoryFactory>();
        ServiceLoader<RepositoryFactory> factories = ServiceLoader.load(RepositoryFactory.class);
        for (RepositoryFactory factory : factories) {
            for (String scheme : factory.getSupportedScheme()) {
                registry.put(scheme, factory);
            }
        }
        return registry;
    }

    private static String[] parseQueryString(URI uri, String fileName) {
        String modelName = null;
        String artifactId = null;
        String query = uri.getQuery();
        if (query != null) {
            Matcher matcher = NAME_PATTERN.matcher(query);
            if (matcher.find()) {
                modelName = matcher.group(1);
            }
            if ((matcher = ARTIFACT_PATTERN.matcher(query)).find()) {
                artifactId = matcher.group(1);
            }
        }
        if (artifactId == null) {
            artifactId = FilenameUtils.getNamePart(fileName);
        }
        if (modelName == null) {
            modelName = artifactId;
        }
        return new String[]{artifactId, modelName};
    }
}

