/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.repository;

import ai.djl.repository.FilenameUtils;
import ai.djl.repository.Metadata;
import ai.djl.repository.Version;
import ai.djl.util.JsonUtils;
import java.io.Serializable;
import java.net.URI;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class Artifact {
    private transient String metadataVersion;
    private String version;
    private boolean snapshot;
    private String name;
    private Map<String, String> properties;
    private Map<String, Object> arguments;
    private Map<String, String> options;
    private Map<String, Item> files;
    private transient Metadata metadata;
    private transient Version cache;

    public String getMetadataVersion() {
        return this.metadataVersion;
    }

    public void setMetadataVersion(String metadataVersion) {
        this.metadataVersion = metadataVersion;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public boolean isSnapshot() {
        return this.snapshot;
    }

    public void setSnapshot(boolean snapshot) {
        this.snapshot = snapshot;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Map<String, String> getProperties() {
        if (this.properties == null) {
            return Collections.emptyMap();
        }
        return this.properties;
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    public Map<String, Object> getArguments(Map<String, Object> override) {
        ConcurrentHashMap<String, Object> map = new ConcurrentHashMap<String, Object>();
        if (this.arguments != null) {
            map.putAll(this.arguments);
        }
        if (override != null) {
            map.putAll(override);
        }
        return map;
    }

    public void setArguments(Map<String, Object> arguments) {
        this.arguments = arguments;
    }

    public Map<String, String> getOptions(Map<String, String> override) {
        ConcurrentHashMap<String, String> map = new ConcurrentHashMap<String, String>();
        if (this.options != null) {
            map.putAll(this.options);
        }
        if (override != null) {
            map.putAll(override);
        }
        return map;
    }

    public void setOptions(Map<String, String> options) {
        this.options = options;
    }

    public Metadata getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Metadata metadata) {
        this.metadata = metadata;
    }

    public URI getResourceUri() {
        URI uri = this.metadata.getRepositoryUri();
        if (this.properties != null) {
            for (String values : this.properties.values()) {
                uri = uri.resolve(values + '/');
            }
        }
        if (this.version == null) {
            return uri;
        }
        return uri.resolve(this.version + '/');
    }

    public Map<String, Item> getFiles() {
        if (this.files == null) {
            return Collections.emptyMap();
        }
        for (Map.Entry<String, Item> file : this.files.entrySet()) {
            file.getValue().setArtifact(this);
        }
        return this.files;
    }

    public void setFiles(Map<String, Item> files) {
        this.files = files;
    }

    public boolean hasProperties(Map<String, String> filter) {
        if (filter == null || filter.isEmpty()) {
            return true;
        }
        if (this.properties == null || this.properties.isEmpty()) {
            return false;
        }
        for (Map.Entry<String, String> entry : filter.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if (value.equals(this.properties.get(key))) continue;
            return false;
        }
        return true;
    }

    public Version getParsedVersion() {
        if (this.cache == null) {
            this.cache = new Version(this.version);
        }
        return this.cache;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(100);
        if (this.metadata != null) {
            sb.append(this.metadata.getGroupId()).append(':').append(this.metadata.getArtifactId()).append(':');
        } else {
            sb.append(this.name).append(':');
        }
        sb.append(this.version == null ? "N/A" : this.version);
        if (this.properties != null) {
            sb.append(' ').append(JsonUtils.GSON.toJson(this.properties));
        } else {
            sb.append(" {}");
        }
        return sb.toString();
    }

    public static final class VersionComparator
    implements Comparator<Artifact>,
    Serializable {
        private static final long serialVersionUID = 1L;

        @Override
        public int compare(Artifact o1, Artifact o2) {
            return o1.getParsedVersion().compareTo(o2.getParsedVersion());
        }
    }

    public static final class Item {
        private String uri;
        private String sha1Hash;
        private String name;
        private String type;
        private long size;
        private transient String extension;
        private transient Artifact artifact;

        public String getUri() {
            return this.uri;
        }

        public void setUri(String uri) {
            this.uri = uri;
        }

        public String getSha1Hash() {
            return this.sha1Hash;
        }

        public void setSha1Hash(String sha1Hash) {
            this.sha1Hash = sha1Hash;
        }

        public String getType() {
            if (this.type == null) {
                this.getExtension();
                this.type = "zip".equals(this.extension) || "tar".equals(this.extension) || "tgz".equals(this.extension) ? "dir" : "file";
            }
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public long getSize() {
            return this.size;
        }

        public void setSize(long size) {
            this.size = size;
        }

        public String getName() {
            if (this.name == null) {
                int pos = this.uri.lastIndexOf(47);
                this.name = pos >= 0 ? this.uri.substring(pos + 1) : this.uri;
                this.name = FilenameUtils.getNamePart(this.name);
            }
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getExtension() {
            if (this.extension == null) {
                this.extension = FilenameUtils.getFileType(this.uri);
            }
            return this.extension;
        }

        public void setExtension(String extension) {
            this.extension = extension;
        }

        public Artifact getArtifact() {
            return this.artifact;
        }

        public void setArtifact(Artifact artifact) {
            this.artifact = artifact;
        }
    }
}

