function executeTrackerLogic() {
  connectif
    .getTrackerId()
    .then(currentTrackerId => {
      if (currentTrackerId && typeof connectifJSBridge?.setTrackerId === 'function') {
        connectifJSBridge.setTrackerId(currentTrackerId);
      } else {
        console.warn("connectifJSBridge.setTrackerId not available yet");
      }
    })
    .catch(error => {
      console.error('Error getting trackerId:', error);
    });
}

(function () {
  if (connectif) {
    executeTrackerLogic();
  } else {
    document.addEventListener('connectif.loaded', function onConnectifLoaded() {
      executeTrackerLogic();
    });
  }
})();

document.addEventListener('connectif.managed.tracker_changed', event => {
  if (typeof connectifJSBridge?.setTrackerId === 'function') {
    connectifJSBridge.setTrackerId(event.detail.newTrackerId);
  }
});
